/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef _KFLICKR_PART_H_
#define _KFLICKR_PART_H_

#include <kstatusbar.h>
#include <kparts/part.h>
#include <kparts/factory.h>
#include <kparts/statusbarextension.h>

#include "kflickrwidget.h"

class KURL;
class QWidget;

/**
 * This is a kflickr "Part".  It allows kflickr to be easily
 * integrated into host applications.
 *
 * @short KFlickr Part
 * @author Mark Asselstine <asselsm@gmail.com>
 * @version 0.6
 */
class kflickrPart : public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    kflickrPart(QWidget *parentWidget, const char *widgetName,
                QObject *parent, const char *name);

    /**
     * Destructor
     */
    virtual ~kflickrPart();

protected:
    /**
     * This must be implemented by each part
     */
    virtual bool openFile();

private slots:
    void setupStatusBar();
    void newPhotoCount(int val);
    void newBandwidthValue(const QString &val);
    
private:
    kflickrWidget &m_widget;
    KStatusBarLabel *m_bandwidth;
    KStatusBarLabel *m_listCount;
    KParts::StatusBarExtension &m_statusBar;
    
signals:
    void bandwidthValue(const QString &);
};

class KInstance;
class KAboutData;

class kflickrPartFactory : public KParts::Factory
{
    Q_OBJECT
public:
    kflickrPartFactory();
    virtual ~kflickrPartFactory();
    virtual KParts::Part* createPartObject(QWidget *parentWidget, const char *widgetName,
                                           QObject *parent, const char *name,
                                           const char *classname, const QStringList &args);
    static KInstance* instance();
 
private:
    static KInstance* s_instance;
    static KAboutData* s_about;
};


#endif // _KFLICKR_PART_H_
