/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "includeexcludeitem.h"

#include <klocale.h>
#include <qdir.h>
#include <klistview.h>

IncludeExcludeItem::IncludeExcludeItem(KListView *parent,QString includeExclude): QListViewItem (parent) 
{ 
	setIncludeExclude(includeExclude);
}

IncludeExcludeItem::IncludeExcludeItem(KListView *parent,IncludeExcludeItem *item,QString includeExclude): QListViewItem (parent,item) 
{ 
	setIncludeExclude(includeExclude);
}


IncludeExcludeItem::~IncludeExcludeItem()
{
}

QString IncludeExcludeItem::includeExclude()
{
	return m_includeExclude;
}

void IncludeExcludeItem::setIncludeExclude(QString includeExclude)
{
	m_includeExclude = includeExclude;
	setIncludeExcludeText();
}

void IncludeExcludeItem::setIncludeExcludeText()
{
	QString type = m_includeExclude.left(1);
	QString file = m_includeExclude.right(m_includeExclude.length() - 1);
	setText(0, file);
	if ( type == "I" )
		setText(1,i18n("Included"));
	else if ( type == "E")
		setText(1,i18n("Excluded"));
}


