/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy   i                                    *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef MISCPROPERTIES_H
#define MISCPROPERTIES_H

#include "MiscProperties_base.h"

class DDataItem;
class MiscProperties : public MiscProperties_base
{
	Q_OBJECT

	public:
		MiscProperties( QWidget* parent, const char* name=0);
		~MiscProperties();

	protected:
		void resizeEvent( QResizeEvent* );

	public slots:
		void setCurrentItem(DDataItem*, bool force=false);
		void updateItem();
		void removePic();

	private:
		DDataItem *m_lastitem;
		void dispInitialPixmap();
};

#endif // MISCPROPERTIES_H
