__all__=('ListOption',)
import string
import UserList
class _ListOption(UserList.UserList):
    def __init__(self, initlist=[], allowedElems=[]):
        UserList.UserList.__init__(self, filter(None, initlist))
        self.allowedElems=allowedElems[:]
        self.allowedElems.sort()
        
    def __cmp__(self, other):
        raise NotImplementedError
    def __eq__(self, other):
        raise NotImplementedError
    def __ge__(self, other):
        raise NotImplementedError
    def __gt__(self, other):
        raise NotImplementedError
    def __le__(self, other):
        raise NotImplementedError
    def __lt__(self, other):
        raise NotImplementedError
    def __str__(self):
        if len(self)==0:
            return 'none'
        self.data.sort()
        if self.data==self.allowedElems:
            return 'all'
        else:
            return string.join(self, ',')
    
def _converter(val, allowedElems):
    """ """
    if val=='none':
        val=[]
    elif val=='all':
        val=allowedElems
    else:
        val=filter(None, string.split(val, ','))
        notAllowed=[]
        for v in val:
            if not v in allowedElems:
                notAllowed.append(v)
        if notAllowed:
            raise ValueError("Invalid value(s) for option: %s" %
                             string.join(notAllowed, ','))
    return _ListOption(val, allowedElems)
def ListOption(key, help, default, names):
    """ """
    names_str='allowed names: %s' % string.join(names, ' ')
    help=string.join(
        (help, '(all|none|comma-separated list of names)', names_str),
        '\n    ')
    return (key, help, default,
            None, #_validator,
            lambda val, elems=names: _converter(val, elems))
