/*
 *   File name:	kdirstatmain.cpp
 *   Summary:	Main program for KDirStat
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <sh@suse.de>
 *		Parts auto-generated by KDevelop
 *
 *   Updated:	2003-01-07
 */


#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kdirstatapp.h"


static const char *description =
	I18N_NOOP("KDirStat - Directory statistics.\n"
		  "\n"
		  "Shows where all your disk space has gone\n"
		  "and helps you clean it up."
		  "\n"
		  "\n"
		  "\n"
		  "If you have any comments or if you would simply like to tell your opinion\n"
		  "about this program, please use \"Send Feedback Mail\" from the \"Help\" menu.\n"
		  "\n"
		  "Any feedback (even negative!) is appreciated."
		  );


static KCmdLineOptions options[] =
{
    { "+[Dir/URL]", I18N_NOOP("Directory or URL to open"), 0 },
    { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "kdirstat", I18N_NOOP("KDirStat"),
			  VERSION, description, KAboutData::License_GPL,
			  "(c) 1999-2003 Stefan Hundhammer", 0, 0,
			  "sh@suse.de" );

    aboutData.addAuthor( "Stefan Hundhammer",
			 I18N_NOOP("\n"
				   "If you have any comments or if you would simply like to tell\n"
				   "your opinion about this program, please use \n"
				   "\"Send Feedback Mail\" from the \"Help\" menu.\n"
				   "\n"
				   "Any feedback (even negative!) is appreciated." ),
			 "sh@suse.de", "http://kdirstat.sourceforge.net/" );


    aboutData.addCredit( I18N_NOOP( "All the people who worked on SequoiaView" ),
			 I18N_NOOP( "for showing just how useful treemaps really can be.\n" ),
			 0,	// e-mail
			 "http://www.win.tue.nl/sequoiaview" );

    aboutData.addCredit( I18N_NOOP( "Jarke J. van Wijk, Huub van de Wetering, and Mark Bruls" ),
			 I18N_NOOP( "for their papers about treemaps.\n" ),
			 "vanwijk@win.tue.nl",
			 "http://www.win.tue.nl/~vanwijk/" );

    aboutData.addCredit( "Ben Shneiderman",
			 I18N_NOOP( "for his ingenious idea of treemaps -\n"
				    "a truly intuitive way of visualizing tree contents.\n" ),
			 "",	// E-Mail
			 "http://www.cs.umd.edu/hcil/treemaps/" );

    aboutData.addCredit( "All the users who gave feedback of any kind",
			 I18N_NOOP( "for showing that all the work involved with such a project\n"
				    "is really appreciated out there.\n" ) );

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication app;

    if ( app.isRestored() )
    {
	RESTORE(KDirStatApp);
    }
    else
    {
	KDirStatApp *kdirstat = new KDirStatApp();
	kdirstat->show();

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	if ( args->count() )
	{
	    // Process command line arguments as URLs or paths to scan

	    KURL url = fixedUrl( args->arg( 0 ) );
	    // kdDebug() << "Opening " << url.url() << endl;
	    kdirstat->openURL( url );
	}
	else
	{
	    kdirstat->fileAskOpenDir();
	}

	args->clear();
    }

    // kdDebug() << "Entering main loop" << endl;

    return app.exec();
}

