// -*- c++ -*-
/***************************************************************************
                           kdetv_v4l2.h
                           ------------
    begin                : Thu Oct 27 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __KDETVV4L2_PLUGIN_H
#define __KDETVV4L2_PLUGIN_H

#include <kdetvsrcplugin.h>
#include <qmap.h>

#include "qvideo.h"

#include "kdetvvideo/kdetvimage.h"

class V4L2Dev;
class V4L2ConfigWidget;
class V4L2Grabber;
class QVideoStream;
class KdetvImageFilterChain;
class KdetvFormatConversionFilter;

/**
 * Video source plugin for Video4Linux2.
 */
class KdetvV4L2 : public KdetvSourcePlugin
{
    Q_OBJECT

public:
    KdetvV4L2(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvV4L2();

    /**
     * To get various values.
     */
    virtual int frequency();
    virtual bool muted();
    virtual bool isTuner();
    virtual int signal();
    virtual QColor colourKey();
    virtual Control::ControlList& controls();

    virtual const QStringList& broadcastedAudioModes();
    virtual const QString&     defaultAudioMode();

    virtual int probeDevices();

    virtual bool videoPlaying() const;

    virtual bool supportsImageFiltering() const { return true; }

public slots:
    /**
     * Sets the device to use.
     */
    virtual int setDevice( const QString &dev );

    /**
     * Sets the channel properties.
     */
    virtual int setChannelProperties(const Channel::PropertyList& properties);

    /**
     * Sets the source to use.
     */
    virtual int setSource( const QString &src );

    /**
     * Sets the tuner mode.
     */
    virtual int setEncoding( const QString &encoding );

    /**
     * Sets the current current channel.
     */
    virtual void setFrequency( int freq );

    /**
     * Mutes the sound.
     */
    virtual void setMuted( bool muted );

    virtual bool setVolume( int left, int right );

    virtual int setAudioMode( const QString& audioMode );

    virtual int startVideo();
    virtual int stopVideo();

    virtual bool canVideoDesktop() const;

    virtual bool canGrabStill() const;
    virtual bool grabStill( QImage *pix );

    virtual QWidget *configWidget(QWidget*, const char *);
    virtual void saveConfig();

private:
    QWidget* _w;
    V4L2Dev* _dev;
    QMap<QString,QString> _devNames;
    bool _probed;
    QVideoStream* _vs;
    QString _currentDev;
    V4L2ConfigWidget* _cfgWidget;
    QVideo::ImageFormat _qvsFormat;

    // Config options
    bool _autoConfig;
    QVideo::VideoMethod _qvsMethod;
    bool _fullFrameRate;
    bool _capturing;

    Control::ControlList _controls;

    V4L2Grabber* _g;

    void calculateGrabFormat(KdetvImageFilterChain* c, KdetvFormatConversionFilter* f);

    int _fieldTime;
    KdetvImage::ImageType _mostRecentField;
    KdetvFormatConversionFilter* _formatConversionFilter;

private slots:
    void viewResized();
    bool event(QEvent* e);
};

#endif

