/***************************************************************************
                          dockwidget.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000-2003 by Ian Reinhart Geiser
                         : (C) 2002-2003 Nadeem Hasan <nhasan@kde.org>
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DOCKWIDGET_H
#define DOCKWIDGET_H

#include <qbutton.h>
#include <qpixmap.h>
#include <qfont.h>

#include <dcopref.h>

class QLabel;
class WeatherService_stub;

class WeatherButton : public QButton
{
  Q_OBJECT

  public:
    WeatherButton( QWidget *parent, const char *name );
    void setPixmap( const QPixmap &pix );

  protected:
    void drawButton( QPainter *p );
    void drawButtonLabel( QPainter *p );
    QSize margin() const { return QSize( 5, 5 ); }
    QSize pixmapSize() const { return size() - margin(); }
    QPoint pixmapOrigin() const;
    void generateIcons();

    void enterEvent( QEvent *e );
    void leaveEvent( QEvent *e );
    void resizeEvent( QResizeEvent *e );

    bool m_highlight;
    QPixmap m_normalIcon;
    QPixmap m_activeIcon;

  protected slots:
    void slotSettingsChanged( int category );
    void slotIconChanged( int group );
};

class dockwidget : public QWidget
{
    Q_OBJECT

public:
    dockwidget(const QString &location, QWidget *parent=0, const char *name=0);
    ~dockwidget();

    enum {ShowIconOnly=1, ShowTempOnly=2, ShowAll=3 };

    void setLocationCode(const QString &locationCode);
    void setViewMode(int);
    void setFont(QFont newFont);
    /** resize the view **/
    void resizeView(const QSize &size);
    int widthForHeight(int h);
    int heightForWidth(int w);

public  slots:
    void showWeather();

signals: // Signals
    void buttonClicked();

private:
    void initDock();
    void updateFont();
    DCOPReply callDCOP( const QString &name );

    int m_mode;
    QString m_locationCode;
    QFont m_font;
    QPixmap m_icon;
    WeatherButton *m_button;
    QLabel *m_lblTemp;
    QLabel *m_lblWind;
    QLabel *m_lblPres;

    WeatherService_stub *m_weatherService;
};

#endif

// vim:ts=4:sw=4:et
