/*
* pop.h -- Declaration of class KPop3Drop.
* Generated by newclass on Tue Apr 21 18:12:41 EST 1998.
*/
#ifndef SSK_POPDROP_H
#define SSK_POPDROP_H

#include<qstring.h>
#include "polldrop.h"
#include "mimelib/string.h"

class DwPopClient;
class QWidget;
class KDropDialog;
class KornMailSubject;

/**
* Polling monitor for POP3 maildrops.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: pop.h,v 1.5 2003/06/11 21:10:06 ravi Exp $
*/
class KPop3Drop : public KPollableDrop
{
private:
	QString _server;
	int	_port;

	QString _user;
	QString _password;
	bool	_savePassword;

	bool _valid;

	bool _apopAuth;

	DwPopClient *_pop;

public:
	static const char *HostConfigKey;
	static const char *PortConfigKey;
	static const char *ApopConfigKey;
	static const char *UserConfigKey;
	static const char *PassConfigKey;
	static const char *SavePassConfigKey;
	static const int  DefaultPort;

public:
	/**
	* KPop3Drop Constructor
	*/
	KPop3Drop();

	/** 
	  * Set the POP3 server that will be checked for new mail.
	 */
	void setPopServer(const QString & server, int port = DefaultPort, bool apop = false);

	/** Set the account information for the POP server. */
	void setUser(const QString & user, const QString & password, bool
		savepwd = false );

	QString server() const { return _server; }
	int port() const { return _port; }

	QString user() const { return _user; }
	QString password() const { return _password; }

	virtual void recheck();

	virtual bool valid();

	virtual bool apopAuth();
	virtual bool canReadSubjects() {return true;}

	/**
	* Read the subjects. The signal readSubjectsTotalSteps() sends the
	* number of message headers to read. The signal readSubjectsProgress()
	* is send after loading each subject. stop stops the loading process.
	*/
	virtual QValueVector<KornMailSubject> * doReadSubjects(bool * stop);
	virtual bool canDeleteMails() {return true;}

	/**
	* Deletes mails. The signal deleteMailsTotalSteps() sends the
	* number of messages to delete. The signal deleteMailsProgress()
	* is send after each mail deletion. stop stops the delete process.
	* Returns true in most cases because the mail ids are invalid if
	* one mail was deleted.
	*/
	virtual bool deleteMails(QPtrList<const KornMailId> * ids, bool * stop);
	virtual bool canReadMail() {return true;}

	/**
	* Reads a mail. The signals readMailTotalSteps() and readMailProgress()
	* are not used, stop is ignored.
	*/
	virtual QString readMail(const KornMailId * id, bool * stop);

	/**
	* KPop3Drop Destructor
	*/
	virtual ~KPop3Drop();


	virtual KMailDrop* clone () const ;
	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;
	virtual QString type() const { return QString::fromUtf8("pop3"); }

	virtual void addConfigPage( KDropCfgDialog * );

private:
	KPop3Drop& operator = ( const KPop3Drop& );
	static void encrypt( QString& str );
	static void decrypt( QString& str );

	/**
	* All steps to open a pop3 connection
	*/
	bool openConnection();
};

#endif // SSK_POPDROP_H
