/***************************************************************************
                          configcontainer.h  -  description
                             -------------------
    begin                : Fre Jan 10 2003
    copyright            : (C) 2003 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CONFIG_CONTAINER_H
#define _CONFIG_CONTAINER_H

#include <qstring.h>

enum speedlevels
{ AUTO, M1, M2, M55, M11 };
enum packetmode
{ UNI, MULTI, BOTH };
enum cryptomodes
{ OPEN, RESTRICTED };

struct configuration_data
{
  QString net_name[5];
  QString script_name[5];
  bool managed[5];
  bool crypto_enabled[5];
  int active_crypto_key[5];
  QString active_key_string[5];
  QString crypto1[5], crypto2[5], crypto3[5], crypto4[5];
  bool crypto_is_string1[5], crypto_is_string2[5], crypto_is_string3[5],
    crypto_is_string4[5];
  cryptomodes crypto_mode[5];
  bool pm_enabled[5];
  int sleep_time[5];
  QString sleep_time_string[5];
  int wake_time[5];
  QString wake_time_string[5];
  speedlevels bitrate[5];
  packetmode packet[5];
};

class Configcontainer
{
public:
  static configuration_data *configs;
  static bool use_preset_config;
  static int preset_config_to_use;
  static QString interface_to_use;
};

#endif
