#include "kmozillapart.h"

#include <dcopclient.h>
#include <dcopobject.h>
#include <kapp.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kmainwindow.h>
#include <kprocess.h>
#include <kparts/mainwindow.h>
#include <kdebug.h>

KMozillaPart::KMozillaPart(QWidget *parent, const char *name)
	: XPartHost_KPart(parent, name)
{
    m_partProcess = new KProcess;
    *m_partProcess << "kmozilla"
		   << kapp->dcopClient()->appId() << objId();
    m_partProcess->start();

    qDebug("---->>>>>> enter loop");
    kapp->enter_loop();
    qDebug("----<<<<<< left loop");
}

KMozillaPart::~KMozillaPart()
{
    delete m_partProcess;
}

void KMozillaPart::createActions( const QCString &xmlActions )
{
    XPartHost_KPart::createActions( xmlActions );
    qDebug("----<<<<<< exit loop");
    kapp->exit_loop();
}

#include "kmozillapart.moc"
