/***************************************************************************
                            KRecentFilesAction.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  This class is an action to handle a recent files submenu.
  The best way to create the action is to use KStdAction.openRecent.
  Then you simply need to call {@link loadEntries} on startup, {@link saveEntries}
  on shutdown, {@link addURL} when your application loads/saves a file.

 See {@link KRecentFilesActionSignals} for signals emitted by KRecentFilesAction.

 See {@link KRecentFilesActionEventHandling} for event handlers to override in subclasses of KRecentFilesAction.

 @author Michael Koch

 @short Recent files action.
*/
public class KRecentFilesAction extends KListAction  {
	protected KRecentFilesAction(Class dummy){super((Class) null);}


/** 

*/
	private native void newKRecentFilesAction( String text, int accel, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, int accel, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, accel, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, int accel, QObject parent);
	public KRecentFilesAction( String text, int accel, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, accel, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( String text, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, accel, receiver, slot, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, int accel, QObject receiver, String slot, QObject parent);
	public KRecentFilesAction( String text, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( String text, QIconSet pix, int accel, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, QIconSet pix, int accel, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, QIconSet pix, int accel, QObject parent);
	public KRecentFilesAction( String text, QIconSet pix, int accel, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( String text, String pix, int accel, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, String pix, int accel, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, String pix, int accel, QObject parent);
	public KRecentFilesAction( String text, String pix, int accel, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, receiver, slot, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent);
	public KRecentFilesAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems);
	public KRecentFilesAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, receiver, slot, parent, name, maxItems);
	}
	private native void newKRecentFilesAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent);
	public KRecentFilesAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKRecentFilesAction( text, pix, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKRecentFilesAction( QObject parent, String name, int maxItems);
	public KRecentFilesAction( QObject parent, String name, int maxItems) {
		super((Class) null);
		newKRecentFilesAction( parent, name, maxItems);
	}
	private native void newKRecentFilesAction();
	public KRecentFilesAction() {
		super((Class) null);
		newKRecentFilesAction();
	}

/** 
  Destructor.
   
*/
	protected native void finalize() throws InternalError;

/** 
  Retrieves the maximum of items in the recent files list.
   
*/
	public native int maxItems();

/** 
  Sets the maximum of items in the recent files list.
  The default for this value is 10 set in the constructor.

  If this value is lesser than the number of items currently
  in the recent files list the last items are deleted until
  the number of items are equal to the new maximum.
   
*/
	public native void setMaxItems( int maxItems);

/** 
  Loads the recent files entries from a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are load from a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
	public native void loadEntries( KConfig config, String groupname);
	public native void loadEntries( KConfig config);

/** 
  Saves the current recent files entries to a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are saved to a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
	public native void saveEntries( KConfig config, String groupname);
	public native void saveEntries( KConfig config);

/** 
  Add URL to recent files list.

*/
	public native void addURL( KURL url);

/** 
  Remove an URL from the recent files list.

*/
	public native void removeURL( KURL url);

/** 
  Removes all entries from the recent files list.
   
*/
	public native void clearURLList();

/** 

   
*/
	protected native void itemSelected( String string);
}
