/***************************************************************************
                            KProtocolManager.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Information about I/O (Internet, etc.) settings.

 KProtocolManager has a heap of static functions that allows you to read
 and write IO related KDE settings. These include proxy settings,
 file transfer resuming, and general timeout settings.

 Note however that these settings apply to all applications.  This means that
 the proxy, timeouts etc. are saved in the users config file and <em>not</em> in the
 config file of the application.

 <code>Original</code> author:

 <code>Revised</code> by:

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short 
 Information about I/O (Internet, etc.
*/
public class  KProtocolManager implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KProtocolManager(Class dummy){}


/** 
 Returns the default user-agent value.

 This function returns the default user-agent value
   
*/
	public static native String defaultUserAgent();

/** 
 Returns the default user-agent value.

 This function returns the default user-agent value
 taking into account 'keys'

 Keys can be any of the folliwing:
 'o'	Show OS
 'v'	Show OS Version
 'p'	Show platform
 'm'	Show machine architecture
 'l'	Show language

   
*/
	public static native String defaultUserAgent( String keys);

/** 
 Returns the userAgent string configured for the
 specified host.

 If hostname is not found or is empty (i.e. "" or
 String.null) this function will return the default
 user agent.

*/
	public static native String userAgentForHost( String arg1);

/** 

 TODO KDE 3.0: remove me
   
*/
	public static native void setUserAgentList( String[] arg1);

/** 

 TODO KDE 3.0: remove me
   
*/
	public static native ArrayList userAgentList();

/** 
 Returns the preferred timeout value for reading from
 remote connections in secs.

 The minimum value that is accept
 is set above or below the threshold limit, this
 function will return the default value given by
 {@link #defaultConnectTimeout}.

*/
	public static native int readTimeout();

/** 
 Returns the preferred timeout value for remote connections
 in secs.

 The maximum value that can be set by the user is 6
 minutes while the minimum is 3 seconds.  If the value
 is set above or below the threshold limit, this
 function will return the default value given by
 {@link #defaultConnectTimeout}.

*/
	public static native int connectTimeout();

/** 
 Returns the preferred timeout value for proxy connections
 in secs.

 The maximum value that can be set by the user is 2
 minutes while the minimum is 3 seconds.  If the value
 is set above or below the threshold limit, this
 function will return the default value given by
 {@link #defaultProxyConnectTimeout}

*/
	public static native int proxyConnectTimeout();

/** 
 Returns the preferred response timeout value for
 remote connecting in secs.

 The maximum value that can be set by the user is 6
 minutes while the minimum is 3 seconds.  If the value
 is set above or below the threshold limit, this
 function will return the default value given by
 {@link #defaultResponseTimeout}

*/
	public static native int responseTimeout();

/** 
 Returns the set default timeout value for connecting
 to remote machines.

*/
	public static native int defaultConnectTimeout();

/** 

 TODO KDE 3.0: Remove
   
*/
	public static native int defaultReadTimeout();

/** 

 TODO KDE 3.0: Remove
   
*/
	public static native int defaultProxyConnectTimeout();

/** 

 TODO KDE 3.0: Remove
   
*/
	public static native int defaultResponseTimeout();

/** 

 TODO KDE 3.0: Remove
   
*/
	public static native int minimumTimeoutThreshold();

/** 
 Sets the amount of time to wait for a response from
 the socket

*/
	public static native void setReadTimeout( int timeout);

/** 
 Sets the amount of time to wait for data arrival
 from the remote/peer machine.

*/
	public static native void setConnectTimeout( int timeout);

/** 
 Sets the amount of time to wait for data arrival
 from the remote/peer machine.

*/
	public static native void setProxyConnectTimeout( int timeout);

/** 
 Sets the amount of time to wait for data arrival
 from the remote/peer machine.

*/
	public static native void setResponseTimeout( int timeout);

/** 
 Returns whether or not the user specified the
 use of proxy server to make connections.
   
*/
	public static native boolean useProxy();

/** 
 Returns whether or not the the proxy server
 lookup should be reversed or not.
   
*/
	public static native boolean useReverseProxy();

/** 
 Returns the type of proxy configuration that is used.
   
*/
	public static native int proxyType();

/** 
 Returns the way proxy authorization should be handled.

*/
	public static native int proxyAuthMode();
	public static native String ftpProxy();
	public static native String httpProxy();

/** 
 Returns the strings for hosts that should contacted
 DIRECT bypassing any proxy settings.
   
*/
	public static native String noProxyFor();
	public static native String proxyFor( String arg1);

/** 
 Returns the Proxy server address for a given URL
 If automatic proxy configuration is configured, {@link KPAC}
 is used to determine the proxy server, otherwise the return
 value of {@link proxyFor} for the URL's protocol is used.
 If an empty string is returned, the request is to be aborted,
 a return value of "DIRECT" requests a direct connection.

*/
	public static native String proxyForURL( KURL arg1);

/** 
 Marks this proxy as bad (down). It will not be used for the
 next 30 minutes. (The script may supply an alternate proxy)
   
*/
	public static native void badProxy( String arg1);

/** 
 This method has been deprecated. Use
 {@link setProxyType} instead.

   
*/
	public static native void setUseProxy( boolean _mode);

/** 
 Sets the proxy exception lookup to be reversed
 and only URLs matching addresses in that list
 use proxy servers.

 Note that this flag only applies if the chosen
 proxy configuration type is either ManualProxy
 or EnvVarProxy. See {@link ProxyType}.

*/
	public static native void setUseReverseProxy( boolean _mode);

/** 
 Set the type of proxy configuration to use.

*/
	public static native void setProxyType( int type);

/** 
 Sets the proxy authorization mode to use.

*/
	public static native void setProxyAuthMode( int mode);

/** 
 Set the proxy for FTP transfer.

 This method has been deprecated, please
 use {@link setProxyFor}.

   
*/
	public static native void setFtpProxy( String _proxy);

/** 
 Set the proxy for HTTP transfer

 This method has been deprecated, please
 use {@link setProxyFor}.

   
*/
	public static native void setHttpProxy( String _proxy);
	public static native void setProxyFor( String arg1, String arg2);

/** 
 Set the URLs for which we should or should not use
 a proxy server.

 In reverse lookup mode only the URL matching addresses
 in this list are allowed to use proxy servers.
   
*/
	public static native void setNoProxyFor( String _noproxy);

/** 

*/
	public static native String proxyConfigScript();

/** 
 Set the URL of the script for automatic proxy configuration
   
*/
	public static native void setProxyConfigScript( String arg1);

/** 
 Returns true/false to indicate whether a cache
 should be used
   
*/
	public static native boolean useCache();
	public static native void setUseCache( boolean _mode);

/** 
 Returns the maximum age (in seconds) cached files
 should be kept before they are deleted.
   
*/
	public static native int maxCacheAge();
	public static native void setMaxCacheAge( int cache_age);

/** 
 Returns the maximum age (in seconds) cached files
 should be kept before they are deleted.
   
*/
	public static native int maxCacheSize();
	public static native void setMaxCacheSize( int cache_size);

/** 
 The directory which contains the cache files
   
*/
	public static native String cacheDir();

/** 
 Returns the Cache control directive to be used.
   
*/
	public static native int cacheControl();

/** 
 Sets the Cache control directive.
   
*/
	public static native void setCacheControl( int arg1);

/**  DOWNLOAD CONFIG 
*/
	public static native boolean autoResume();
	public static native boolean markPartial();
	public static native int minimumKeepSize();
	public static native boolean persistentConnections();

/** 
 Set this flag if you want slaves to add the extension .PART to all
 files during transfer.  This extension will be removed when file is
 fully transferred.

 This is a better way to discern finished transfers in case
 of transfer errors.

*/
	public static native void setMarkPartial( boolean _mode);

/** 
 Set the minimum size for keeping an interrupted transfer.

 A downloaded file whose transfer was interrupted will only be kept if
 its size is bigger than @ _size, otherwise it will be deleted.

 Default value is 5000 bytes
   
*/
	public static native void setMinimumKeepSize( int _size);

/** 
 Set this flag if you want slaves to automatically resume
 downloading files without asking the user in the "rename" dialog.

*/
	public static native void setAutoResume( boolean _mode);

/** 
 Set this flag if you want slaves to have persistent connections (FTP).

*/
	public static native void setPersistentConnections( boolean _mode);

/** 
 Force a reload of the general config file of
 io-slaves ( kioslaverc).
   
*/
	public static native void reparseConfiguration();

/** 
 Return the protocol to use in order to handle the given <code>url</code>
 It's usually the same, except that FTP, when handled by a proxy,
 needs an HTTP ioslave.

 When a proxy is to be used, proxy contains the URL for the proxy.
   
*/
	public static native String slaveProtocol( KURL url, String proxy);
	public static native String slaveProtocol( String protocol);
	public static final int NoProxy = 0;
	public static final int ManualProxy = 1;
	public static final int PACProxy = 2;
	public static final int WPADProxy = 3;
	public static final int EnvVarProxy = 4;
	public static final int Prompt = 0;
	public static final int Automatic = 1;
}
