/***************************************************************************
                            KLineEdit.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An enhanced QLineEdit widget for inputting text.

 This widget inherits from {@link QLineEdit} and implements the following
 additional functionalities: q completion object that provides both
 automatic and manual text completion as well as multiple match iteration
 features, configurable key-bindings to activate these features and a
 popup-menu item that can be used to allow the user to set text completion
 modes on the fly based on their preference.

 To support these new features {@link KLineEdit} also emits a few more
 additional signals.  These are: {@link #completion},
 textRotation( KeyBindingType ), and {@link #returnPressed}.
 The completion signal can be connected to a slot that will assist the
 user in filling out the remaining text.  The text rotation signal is
 intended to be used to iterate through the list of all possible matches
 whenever there is more than one match for the entered text.  The
 <code>returnPressed</code>( String ) signals are the same as QLineEdit's
 except it provides the current text in the widget as its argument whenever
 appropriate.

 This widget by default creates a completion object when you invoke
 the {@link #completionObject} member function for the first time or
 use {@link #setCompletionObject} to assign your own
 completion object.  Additionally, to make this widget more functional,
 {@link KLineEdit} will by default handle the text rotation and completion
 events internally when a completion object is created through either one
 of the methods mentioned above.  If you do not need this functionality,
 simply use {@link KCompletionBase#setHandleSignals} or set the
 boolean parameter in the above functions to FALSE.

 The default key-bindings for completion and rotation is determined
 from the global settings in {@link KStdAccel}.  These values, however,
 can be overriden locally by invoking {@link KCompletionBase#setKeyBinding}.
 The values can easily be reverted back to the default setting, by simply
 calling {@link #useGlobalSettings}. An alternate method would be to default
 individual key-bindings by usning {@link #setKeyBinding} with the default
 second argument.

 NOTE that if the <code>EchoMode</code> for this widget is set to something other
 than <code>QLineEdit.Normal</code>, the completion mode will always be defaulted
 to {@link KGlobal#CompletionNone}.  This is done purposefully to guard
 against protected entries such as passwords being cached in {@link KCompletion}'s
 list. Hence, if the <code>EchoMode</code> is not {@link QLineEdit#Normal}, the completion
 mode is automatically disabled.

 To enable the basic completion feature :

 <pre>
 KLineEdit edit = new KLineEdit( this, "mywidget" );
 KCompletion comp = edit.completionObject();
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>

 To use a customized completion objects or your
 own completion object :

 <pre>
 KLineEdit edit = new KLineEdit( this,"mywidget" );
 KURLCompletion comp = new KURLCompletion();
 edit.setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 <pre>
 // Tell the widget not to handle completion and
 // iteration internally.
 edit.setHandleSignals( false );
 // Set your own completion key for manual completions.
 edit.setKeyBinding( KCompletionBase.TextCompletion, Qt.End );
 // Hide the context (popup) menu
 edit.setContextMenuEnabled( false );
 // Temporarly disable signal emitions
 // (both completion & iteration signals)
 edit.disableSignals();
 // Default the key-bindings to system settings.
 edit.useGlobalKeyBindings();
 </pre>

 See {@link KLineEditSignals} for signals emitted by KLineEdit.

 See {@link KLineEditEventHandling} for event handlers to override in subclasses of KLineEdit.

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced single line input widget.

*/
public class KLineEdit extends QLineEdit implements  KCompletionBaseInterface {
	protected KLineEdit(Class dummy){super((Class) null);}


/** 
 Construct a {@link KLineEdit} object with a default text, a parent,
 and a name.

*/
	private native void newKLineEdit( String string, QWidget parent, String name);
	public KLineEdit( String string, QWidget parent, String name) {
		super((Class) null);
		newKLineEdit( string, parent, name);
	}
	private native void newKLineEdit( String string, QWidget parent);
	public KLineEdit( String string, QWidget parent) {
		super((Class) null);
		newKLineEdit( string, parent);
	}

/** 
 Construct a {@link KLineEdit} object with a parent and a name.

*/
	private native void newKLineEdit( QWidget parent, String name);
	public KLineEdit( QWidget parent, String name) {
		super((Class) null);
		newKLineEdit( parent, name);
	}
	private native void newKLineEdit();
	public KLineEdit() {
		super((Class) null);
		newKLineEdit();
	}

/** 
  Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Sets <code>url</code> into the lineedit. It uses {@link KURL#prettyURL} so
 that the url is properly decoded for displaying.
     
*/
	public native void setURL( KURL url);

/** 
 Put cursor at the end of the string.

 This method is deprecated.  Use {@link QLineEdit#end}
 instead.

 {@link QLineEdit#end}
     
*/
	public native void cursorAtEnd();

/** 
 Re-implemented from {@link KCompletionBase} for internal reasons.

 This function is re-implemented in order to make sure that
 the EchoMode is acceptable before we set the completion mode.

 See {@link KCompletionBase#setCompletionMode}
     
*/
	public native void setCompletionMode( int mode);

/** 
 Enables/disables the popup (context) menu.

 Note that when this function is invoked with its argument
 set to <code>true</code>, then both the context menu and the completion
 menu item are enabled.  If you do not want to the completion
 item to be visible simply invoke {@link #hideModechanger} right
 after calling this method.  Also by default, the context
 menu is automatically created if this widget is editable. Thus
 you need to call this function with the argument set to false
 if you do not want this behaviour.

*/
	public native void setContextMenuEnabled( boolean showMenu);

/** 
 Returns <code>true</code> when the context menu is enabled.

*/
	public native boolean isContextMenuEnabled();

/** 
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QLineEdit is used, which inserts the encoded URL.

*/
	public native void setURLDropsEnabled( boolean enable);

/** 
 Returns <code>true</code> when decoded URL drops are enabled

*/
	public native boolean isURLDropsEnabled();

/** 
 By default, {@link KComboBox} recognizes <code>Key_Return</code> and <code>Key_Enter</code> and emits
 the {@link #returnPressed} signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with <code>trap</code> = <code>true</code> to make <code>KComboBox</code> stop these
 events. The signals will still be emitted of course.

 Only affects read-writable comboboxes.

*/
	public native void setTrapReturnKey( boolean trap);

/** 

*/
	public native boolean trapReturnKey();

/** 

*/
//	public native KCompletionBox completionBox();

/** 

*/
//	public native KCompletionBox completionBox( boolean create);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	public native void setCompletionObject( KCompletion arg1, boolean hsig);
	public native void setCompletionObject( KCompletion arg1);

/** 
 Iterate through all possible matches of the completed text or
 the history list.

 This function simply iterates over all possible matches in case
 multimple matches are found as a result of a text completion request.
 It will have no effect if only a single match is found.

*/
	public native void rotateText( int arg1);

/** 
 See {@link KCompletionBase#setCompletionText}.
     
*/
	public native void setCompletedText( String arg1);

/** 
 Sets <code>items</code> into the completion-box if {@link #completionMode} is
 CompletionPopup. The popup will be shown immediately.
     
*/
	public native void setCompletedItems( String[] items);
	protected native void setCompletedText( String arg1, boolean arg2);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	protected native void create( int arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create();

/** 
 Complete the remaining text with a matching one from
 a given list.
    
*/
	protected native void makeCompletion( String arg1);

/** 

     
*/
	protected native void slotAboutToShow();

/** 

     
*/
	protected native void slotCancelled();
/**
 Returns a pointer to the current completion object.

 If the object does not exist, it is automatically
 created.  Note that the completion object created
 here is used by default to handle the signals
 internally.  It is also deleted when this object's
 destructor is invoked.  If you do not want these
 default settings, use {@link setAutoDeleteCompletionObject}
 and {@link setHandleSignals} to change the behavior.
 Alternatively, you can set the boolean parameter to
 false to disable the automatic handling of the signals
 by this object.  Note that the boolean argument will be
 ignored if there already exists a completion object since
 no new object needs to be created. You need to use either
 {@link setHandleSignals} or {@link setCompletionObject} for
 such cases depending on your requirement.

*/
	public native KCompletion completionObject( boolean hsig);
	public native KCompletion completionObject();

/**
 Overloaded method to specify whether a completion-object should be
 created or not. If <code>create</code> is set to false and there is no
 completion-object yet, 0L will be returned.

*/
	public native KCompletion completionObject( boolean create, boolean hsig);

/**
 Sets up the completion object to be used.

 This method assigns the completion object and sets it
 up to automatically handle the completion and rotation
 signals internally.  You should use this function if
 you want to share one completion object among you widgets
 or need to use a customized completion object.

 The object assigned through this method is not deleted
 when this object's destructor is invoked unless you
 explicitly call {@link setAutoDeleteCompletionObject} after
 calling this method.  Also if you do not want the signals
 to be handled by an internal implementation, be sure to
 set the boolean argument to false.

*/
//	public native void setCompletionObject( KCompletion arg1, boolean hsig);
//	public native void setCompletionObject( KCompletion arg1);

/**
 Enables this object to handle completion and rotation
 events internally.

 This function simply assigns a boolean value that
 indicates whether it should handle rotation and
 completion events or not.  Note that this does not
 stop the object from emitting signals when these
 events occur.

*/
	public native void setHandleSignals( boolean arg1);

/**
 Returns true if the completion object is deleted
 upon this widget's destruction.

 See {@link #setCompletionObject} and {@link #enableCompletion}
 for details.

*/
	public native boolean isCompletionObjectAutoDeleted();

/**
 Sets the completion object when this widget's destructor
 is called.

 If the argument is set to true, the completion object
 is deleted when this widget's destructor is called.

*/
	public native void setAutoDeleteCompletionObject( boolean autoDelete);

/**
 Sets the widget's ability to emit text completion and
 rotation signals.

 Invoking this function with <code>enable</code> set to <code>false</code> will
 cause the completion & rotation signals not to be emitted.
 However, unlike setting the completion object to <code>NULL</code>
 using {@link setCompletionObject}, disabling the emition of
 the signals through this method does not affect the current
 completion object.

 There is no need to invoke this function by default.  When a
 completion object is created through {@link completionObject} or
 {@link setCompletionObject}, these signals are set to emit
 automatically.  Also note that disabling this signals will not
 necessarily interfere with the objects ability to handle these
 events internally.  See {@link setHandleSignals}.

*/
	public native void setEnableSignals( boolean enable);

/**
 Returns true if the object handles the signals

*/
	public native boolean handleSignals();

/**
 Returns true if the object emits the signals

*/
	public native boolean emitSignals();


/**
 Retrieves the current completion mode.

 The return values are of type {@link KGlobalSettings#Completion}.
 See {@link #setCompletionMode} for details.

*/
	public native int completionMode();

/**
 Sets the key-binding to be used for manual text
 completion, text rotation in a history list as
 well as a completion list.

 When the keys set by this function are pressed, a
 signal defined by the inherting widget will be activated.
 If the default value or 0 is specified by the second
 parameter, then the key-binding as defined in the global
 setting should be used.  This method returns false value
 for <code>key</code> is negative or the supplied key-binding conflicts
 with the ones set for one of the other features.

 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
 the key-binding simply simply <code>sum</code> up the values of the
 modifier and the actual key.  For example, to use CTRL+E as
 a key binding for one of the items, you would simply supply
 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
 function.

*/
	public native boolean setKeyBinding( int arg1, int key);
	public native boolean setKeyBinding( int arg1);

/**
 Returns the key-binding used for the specified item.

 This methods returns the key-binding used to activate
 the feature feature given by <code>item.</code>  If the binding
 contains modifier key(s), the SUM of the modifier key
 and the actual key code are returned.

*/
	public native int getKeyBinding( int item);

/**
 Sets this object to use global values for key-bindings.

 This method changes the values of the key bindings for
 rotation and completion features to the default values
 provided in KGlobalSettings.

 NOTE: By default inheriting widgets should uses the
 global key-bindings so that there will be no need to
 call this method.

*/
	public native void useGlobalKeyBindings();
}
