/***************************************************************************
                            KKeyChooser.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Configure dictionaries of key/action associations for KAccel and
 KGlobalAccel.

 The class takes care of all aspects of configuration, including
 handling key conflicts internally. Connect to the {@link #allDefault}
 slot if you want to set all configurable keybindings to their
 default values.

 
 See {@link KKeyChooserSignals} for signals emitted by KKeyChooser.

 See {@link KKeyChooserEventHandling} for event handlers to override in subclasses of KKeyChooser.

 @author Nicolas Hadacek <hadacek@via.ecp.fr>

 @version $Id: KKeyChooser.java,v 1.3.2.1 2001/08/29 23:14:10 rdale Exp $

 @short Widget for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyChooser extends QWidget  {
	protected KKeyChooser(Class dummy){super((Class) null);}


/** 
 Constructor.

*/
//	private native void newKKeyChooser( KKeyEntryMap aKeyMap, KKeyMapOrder* pMapOrder, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts, boolean bAllowMetaKey);
//	public KKeyChooser( KKeyEntryMap aKeyMap, KKeyMapOrder* pMapOrder, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts, boolean bAllowMetaKey) {
//		super((Class) null);
//		newKKeyChooser( aKeyMap, pMapOrder, parent, check_against_std_keys, bAllowLetterShortcuts, bAllowMetaKey);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyMap, KKeyMapOrder* pMapOrder, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts);
//	public KKeyChooser( KKeyEntryMap aKeyMap, KKeyMapOrder* pMapOrder, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts) {
//		super((Class) null);
//		newKKeyChooser( aKeyMap, pMapOrder, parent, check_against_std_keys, bAllowLetterShortcuts);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyMap, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts, boolean bAllowMetaKey);
//	public KKeyChooser( KKeyEntryMap aKeyMap, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts, boolean bAllowMetaKey) {
//		super((Class) null);
//		newKKeyChooser( aKeyMap, parent, check_against_std_keys, bAllowLetterShortcuts, bAllowMetaKey);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyMap, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts);
//	public KKeyChooser( KKeyEntryMap aKeyMap, QWidget parent, boolean check_against_std_keys, boolean bAllowLetterShortcuts) {
//		super((Class) null);
//		newKKeyChooser( aKeyMap, parent, check_against_std_keys, bAllowLetterShortcuts);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys);
//	public KKeyChooser( KKeyEntryMap aKeyDict, QWidget parent, boolean check_against_std_keys) {
//		super((Class) null);
//		newKKeyChooser( aKeyDict, parent, check_against_std_keys);
//	}
//	private native void newKKeyChooser( KKeyEntryMap aKeyDict);
//	public KKeyChooser( KKeyEntryMap aKeyDict) {
//		super((Class) null);
//		newKKeyChooser( aKeyDict);
//	}
	protected native void finalize() throws InternalError;

/** 
 Set all keys to their default values (bindings).

*/
	public native void allDefault();
	public native void allDefault( boolean useFourModifierKeys);
	public native void setPreferFourModifierKeys( boolean preferFourModifierKeys);

/** 
 Set all list entries to their changed values.
 Use this if you changed the underlying map

*/
	public native void listSync();
//	protected native void init( KKeyEntryMap aKeyMap, KKeyMapOrder* pMapOrder, boolean check_against_std_keys, boolean bAllowLetterShortcuts, boolean bAllowMetaKey);
	protected native void fontChange( QFont _font);
	protected native boolean isKeyPresent( int kcode, boolean warnuser);
	protected native boolean isKeyPresent( int kcode);
	protected native void setKey( int kCode);
	protected native void toChange( QListViewItem item);
	protected native void changeKey();
	protected native void capturedKey( int key);
	protected native void updateAction( QListViewItem item);
	protected native void defaultKey();
	protected native void noKey();
	protected native void keyMode( int _mode);
	protected native void shiftClicked();
	protected native void ctrlClicked();
	protected native void altClicked();
	protected native void editKey();
	protected native void editEnd();
	protected native void readGlobalKeys();
	protected native void readStdKeys();
	public static final int NoKey = 1;
	public static final int DefaultKey = 0;
	public static final int CustomKey = 1;
}
