/***************************************************************************
                            KJavaProcess.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 See {@link KJavaProcessSignals} for signals emitted by KJavaProcess.

 See {@link KJavaProcessEventHandling} for event handlers to override in subclasses of KJavaProcess.

*/
public class KJavaProcess extends QObject  {
	protected KJavaProcess(Class dummy){super((Class) null);}


/** 
 Creates a process object, the process is NOT invoked at this point.
 You should first set the process's parameters, and then call startJava.
     
*/
	private native void newKJavaProcess();
	public KJavaProcess() {
		super((Class) null);
		newKJavaProcess();
	}
	protected native void finalize() throws InternalError;

/** 
 Invoke the JVM with the parameters that have been set.  The Java process
 will start after this call.
     
*/
	public native boolean startJava();

/** 
 Stop the JVM (if it's running).
     
*/
	public native void stopJava();

/** 
 Returns the status of the java Process- true if it's ok, false if it has died.
 It calls KProcess.isRunning()
     
*/
	public native boolean isRunning();

/** 
 Used to specify the path to the Java executable to be run.
     
*/
	public native void setJVMPath( String path);

/** 
 This will set the classpath the Java process will use.  It's used as a the
 -cp command line option.  It adds every jar file stored in $KDEDIRS/share/apps/kjava/
 to the classpath, and then adds the $CLASSPATH environmental variable.  This allows
 users to simply drop the JSSE (Java Secure Sockets Extension classes into that directory
 without having to modify the jvm configuration files.
     
*/
	public native void setClasspath( String classpath);

/** 
 Set a property on the java command line as -Dname=value, or -Dname if value is String.null.
 For example, you could call setSystemProperty( "kjas.debug", "" ) to set the kjas.debug property.
     
*/
	public native void setSystemProperty( String name, String value);

/** 
 The class to be called when startJava() is called.
     
*/
	public native void setMainClass( String clazzName);

/** 
 Extra flags passed to the JVM.
     
*/
	public native void setExtraArgs( String args);

/** 
 Arguments passed to the main class.  They will be very last in the java
 command line, after the main class.
     
*/
	public native void setClassArgs( String classArgs);

/** 
 Sends a command to the KJAS Applet Server by building a byte[]
 out of the data, and then writes it standard out.
     
*/
	public native void send( char cmd_code, String[] args);

/** 
 Sends a command to the KJAS Applet Server by building a byte[]
 out of the data, and then writes it standard out.  It adds each String
 in the arg list, and then adds the data array.
     
*/
	public native void send( char cmd_code, String[] args, byte[] data);
	protected native boolean invokeJVM();
	protected native void killJVM();
	protected native byte[] addArgs( char cmd_code, String[] args);
	protected native void popBuffer();
	protected native void sendBuffer( byte[] buff);
	protected native void storeSize( byte[] buff);

/** 
 This slot is called whenever something is written to stdin of the process.
 It's called again to make sure we keep emptying out the buffer that contains
 the messages we need send.
     
*/
	protected native void slotWroteData();

/** 
 This slot is called when the Java Process writes to standard out.  We then
 process the data from the file descriptor that is passed to us and send the
 command to the AppletServer
     
*/
	protected native void slotReceivedData( int arg1, int arg2);
}
