/***************************************************************************
                            KIntValidator.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  {@link QValidator} for integers.

  This can be used by {@link QLineEdit} or subclass to provide validated
  text entry.  Can be provided with a base value (default is 10), to allow
  the proper entry of hexadecimal, octal, or any other base numeric data.

 See {@link KIntValidatorSignals} for signals emitted by KIntValidator.

 See {@link KIntValidatorEventHandling} for event handlers to override in subclasses of KIntValidator.

 @author Glen Parker <glenebob@nwlink.com>

 @version 0.0.1

 @short 
  @ref QValidator for integers.
*/
public class KIntValidator extends QValidator  {
	protected KIntValidator(Class dummy){super((Class) null);}


/** 
      Constuctor.  Also sets the base value.
    
*/
	private native void newKIntValidator( QWidget parent, int base, String name);
	public KIntValidator( QWidget parent, int base, String name) {
		super((Class) null);
		newKIntValidator( parent, base, name);
	}
	private native void newKIntValidator( QWidget parent);
	public KIntValidator( QWidget parent) {
		super((Class) null);
		newKIntValidator( parent);
	}

/** 
      Constuctor.  Also sets the minimum, maximum, and numeric base values.
    
*/
	private native void newKIntValidator( int bottom, int top, QWidget parent, int base, String name);
	public KIntValidator( int bottom, int top, QWidget parent, int base, String name) {
		super((Class) null);
		newKIntValidator( bottom, top, parent, base, name);
	}
	private native void newKIntValidator( int bottom, int top, QWidget parent);
	public KIntValidator( int bottom, int top, QWidget parent) {
		super((Class) null);
		newKIntValidator( bottom, top, parent);
	}

/** 
      Destructor.
    
*/
	protected native void finalize() throws InternalError;

/** 
      Validate the text, and return the result.  Does not modify the paramaters.
    
*/
	public native int validate( StringBuffer arg1, int[] arg2);

/** 
      Fix the text if possible, providing a valid string.  The parameter may be modified.
    
*/
	public native void fixup( StringBuffer arg1);

/** 
      Set the minimum and maximum values allowed.
    
*/
	public native void setRange( int bottom, int top);

/** 
      Set the numeric base value.
    
*/
	public native void setBase( int base);

/** 
      Return the current minimum value allowed.
    
*/
	public native int bottom();

/** 
      Return the current maximum value allowed.
    
*/
	public native int top();

/** 
      Return the current numeric base.
    
*/
	public native int base();
}
