/***************************************************************************
                          devicepopupmenu.h  -  description
                             -------------------
    begin                : lun ao 4 2003
    copyright            : (C) 2003 by ervin
    email                : ervin at tuxfamily dot org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEVICEPOPUPMENU_H
#define DEVICEPOPUPMENU_H

#include <qwidget.h>
#include <kpopupmenu.h>
#include <kfileitem.h>
#include <kmimetype.h> // for KDEDesktopMimeType

/**
  *@author ervin
  */

class DevicePopupMenu : public KPopupMenu
{
   Q_OBJECT

public: 
	DevicePopupMenu(const KFileItem &fileItem, QWidget *parent=0);
	~DevicePopupMenu();

protected:
	inline void queryMountWatcher();
	inline void loadServices();
	
protected slots:
	void slotRunService(int id);

private:
	KFileItem mFileItem;
	KURL mMountPoint;
	bool mMounted;

	KPopupMenu mServicesSubMenu;

	QMap<int, KDEDesktopMimeType::Service> mServicesMap;
	QValueList<KDEDesktopMimeType::Service> mDeviceServices;
	QValueList<KDEDesktopMimeType::Service> mDirectoryServices;
};

#endif
