// $Id: pgmsettings.cpp,v 1.2 2000/03/18 14:24:53 jsixt Exp $

// Copyright by Johannes Sixt
// This file is under GPL, the GNU General Public Licence

#include "pgmsettings.h"
#if QT_VERSION >= 200
#include <klocale.h>			/* i18n */
#endif
#include <kapp.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include "config.h"
#include "mydebug.h"


ChooseDriver::ChooseDriver(QWidget* parent) :
	QWidget(parent, "driver")
{
    QVBoxLayout* layout = new QVBoxLayout(this, 10);

    QLabel* label = new QLabel(this);
    label->setText(i18n("How to invoke &GDB - leave empty to use\n"
			"the default from the global options:"));
    label->setMinimumSize(label->sizeHint());
    layout->addWidget(label);

    m_debuggerCmd = new QLineEdit(this);
    m_debuggerCmd->setMinimumSize(m_debuggerCmd->sizeHint());
    layout->addWidget(m_debuggerCmd);
    label->setBuddy(m_debuggerCmd);

    layout->addStretch(10);
}

void ChooseDriver::setDebuggerCmd(const QString& cmd)
{
    m_debuggerCmd->setText(cmd);
}

QString ChooseDriver::debuggerCmd() const
{
    return m_debuggerCmd->text();
}


OutputSettings::OutputSettings(QWidget* parent) :
	QWidget(parent, "output")
{
    // the group is invisible
    m_group = new QButtonGroup(this);
    m_group->hide();

    QVBoxLayout* layout = new QVBoxLayout(this, 10);

    QRadioButton* btn;

    btn = new QRadioButton(i18n("&No input and output"), this);
    m_group->insert(btn, 0);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    btn = new QRadioButton(i18n("&Only output, simple terminal emulation"), this);
    m_group->insert(btn, 1);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    btn = new QRadioButton(i18n("&Full terminal emulation"), this);
    m_group->insert(btn, 7);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    layout->addStretch(10);

    // there is no simpler way to get to the active button than
    // to connect to a signal
    connect(m_group, SIGNAL(clicked(int)), SLOT(slotLevelChanged(int)));
}

void OutputSettings::setTTYLevel(int l)
{
    m_group->setButton(l);
    m_ttyLevel = l;
}

void OutputSettings::slotLevelChanged(int id)
{
    m_ttyLevel = id;
    TRACE("new ttyLevel: " + QString().setNum(id));
}



ProgramSettings::ProgramSettings(QWidget* parent, QString exeName, bool modal) :
	QTabDialog(parent, "program_settings", modal),
	m_chooseDriver(this),
	m_output(this)
{
    // construct title
    int slash = exeName.findRev('/');
    if (slash >= 0) {
#if QT_VERSION < 200
	exeName.detach();
#endif
	exeName.remove(0, slash+1);
    }
    QString cap = kapp->getCaption();
    QString fmt = i18n("%s: Settings for %s");
    SIZED_QString(title, fmt.length() + cap.length() + exeName.length());
    title.sprintf(fmt, cap.data(), exeName.data());
    setCaption(title);

    setCancelButton(i18n("Cancel"));
    setOKButton(i18n("OK"));
    setDefaultButton(i18n("&Help"));

    connect(this, SIGNAL(defaultButtonPressed()), SLOT(slotHelp()));

    addTab(&m_chooseDriver, i18n("&Debugger"));
    addTab(&m_output, i18n("&Output"));
}

void ProgramSettings::slotHelp()
{
    QString section;

#if QT_VERSION >= 200
    // find active page and jump to its section
    QWidget* curWidget = currentPage();
    if (curWidget != 0) {
	section = curWidget->name();
    }
#endif
    TRACE("invoking help: pgmsettings.html section #" + section);
    kapp->invokeHTMLHelp("kdbg/pgmsettings.html", section);
}

#include "pgmsettings.moc"
