/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BIBTEXFILEEXPORTERBIBUTILS_H
#define BIBTEXFILEEXPORTERBIBUTILS_H

#include <fileexporter.h>

class QProcess;
class QBuffer;

namespace BibTeX
{
    class FileExporterBibTeX;

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class FileExporterBibUtils : public FileExporter
    {
         Q_OBJECT
   public:
        FileExporterBibUtils( BibTeX::File::FileFormat outputFormat );
        ~FileExporterBibUtils();

        bool save( QIODevice* iodevice, const Element* element, QStringList* errorLog = NULL );
        bool save( QIODevice* iodevice, const File* bibtexfile, QStringList* errorLog = NULL );

    public slots:
        void cancel();

    private:
        bool m_cancelFlag;
        BibTeX::File::FileFormat m_outputFormat;
        FileExporterBibTeX *m_bibTeXExporter;

        bool m_waiting;
        QProcess *m_process;
        QBuffer *m_processBuffer;

        bool toBuffer( const File *bibFile, QBuffer *buffer, QStringList* errorLog);
        bool toBuffer( const Element *bibFile, QBuffer *buffer, QStringList* errorLog);
        bool bufferToXMLbuffer( QBuffer *buffer );
        bool xmlBufferToIOdevice( QIODevice *iodevice );

    private slots:
        void wakeUp();
        void slotReadyStdout();
        void slotReadyStderr();
    };

}

#endif // BIBTEXFILEEXPORTERBIBUTILS_H
