/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef SETTINGS_H
#define SETTINGS_H

#include <qstringlist.h>

#include <kcompletion.h>

#include <file.h>
#include <fileexporterexternal.h>
#include <entryfield.h>

class KConfig;
class KStandardDirs;
class KURL;
class QString;
class QChar;
class QFont;
class BibTeX::Element;

namespace KBibTeX
{
    class Settings
    {
    public:
        struct SearchURL
        {
            QString description;
            QString url;
        };

    public:
        static Settings* self();

        void load( KConfig * config );
        void save( KConfig * config );

        static QString fieldTypeToI18NString( const BibTeX::EntryField::FieldType fieldType );
        static KURL doiURL( const QString& doiText );

    public:
        // FileIO section
        BibTeX::File::Encoding fileIO_Encoding;
        QString fileIO_ExportLanguage;
        QString fileIO_ExportBibliographyStyle;
        QChar fileIO_BibtexStringOpenDelimiter;
        QChar fileIO_BibtexStringCloseDelimiter;
        BibTeX::FileExporterExternal::Exporter fileIO_ExporterHTML;

        // Editing section
        bool editing_EnableAllFields;
        int editing_MainListDoubleClickAction;
        int editing_MainListSortingColumn;
        int editing_MainListSortingOrder;
        QStringList editing_FilterHistory;
        bool editing_ShowMacros;
        bool editing_ShowComments;
        QValueList<int> editing_MainListColumnsWidth;
        QValueList<int> editing_MainListColumnsIndex;
        QValueList<int> editing_HorSplitterSizes;
        QValueList<int> editing_VertSplitterSizes;
        QFont editing_SpecialFont;
        bool editing_UseSpecialFont;

        // SearchURLs section
        QValueList<SearchURL*> searchURLs;

        // External section
        QString external_XSLTStylesheetHTML;
        bool external_bibconvAvailable;
        bool external_bibtex2htmlAvailable;
        bool external_bib2xhtmlAvailable;
        bool external_latex2rtfAvailable;

        // Auto-completion for user fields (non-persistant)
        void addToCompletion( BibTeX::File *file );
        void addToCompletion( BibTeX::Element *element );
        KCompletion* completion( BibTeX::EntryField::FieldType fieldType );

        void restoreDefaultSearchURLs();

    private:
        KCompletion **m_completion;

        Settings();
        ~Settings();

        void checkExternalToolsAvailable();
        bool checkExternalToolAvailable( const QString &binary );

        int completionFieldTypeToIndex( BibTeX::EntryField::FieldType fieldType );
    };
}

#endif
