/***************************************************************************
                          kbearsitemanageriface.h  -  description
                             -------------------
    begin                : lr mar 16 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERIFACE_H
#define KBEARSITEMANAGERIFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <dcopobject.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "../../base/site.h"
#include "../../base/group.h"

/**
  *@author Bjrn Sahlstrm
  */

class KBearSiteManagerDCOPIface : virtual public DCOPObject  {
	K_DCOP
k_dcop:
	/** */
	virtual ASYNC slotNewSite( Site site ) = 0;
	/**	*/
	virtual ASYNC slotSiteChanged( Site site, QString oldName ) = 0;
	/** */
	virtual ASYNC slotSiteRemoved( Site site ) = 0;
	/**	*/
	virtual ASYNC slotSiteMoved( Site site, QString oldParent, QString oldName ) = 0;
	/**	*/
	virtual ASYNC slotNewGroup( Group group ) = 0;
	/**	*/
	virtual ASYNC slotGroupChanged( Group group, QString oldName ) = 0;
	/**	*/
	virtual ASYNC slotGroupRemoved( Group group ) = 0;
	/**	*/
	virtual ASYNC slotGroupMoved( Group site, QString oldParent ) = 0;
	/**	*/
	virtual ASYNC slotEncodingChanged( QString encoding ) = 0;
	/**	*/
	virtual ASYNC slotUpdateDatabase( QString domTree ) = 0;
	/**	*/
	virtual ASYNC slotInit() = 0;
	/**	*/
	virtual ASYNC slotImportOldSitemanager( QString ) = 0;
	/**	*/
	virtual ASYNC setShowSystemTray( bool ) = 0;
	/** */
	virtual ASYNC setPlugInKonq( bool ) = 0;
};

#endif
