/***************************************************************************
                          kbeariconview.cpp  -  description
                             -------------------
    begin                : lr jan 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtextcodec.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#if QT_VERSION < 300
#include <kapp.h>
#else
#include <kapplication.h>
#endif
#include <kglobal.h>
#include <kcharsets.h>
#include <kfile.h>
#include <kaction.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeariconview.h"

//-----------------------------------------------
KBearIconView::KBearIconView(QWidget *parent, const char *name, const Connection& c )
	:	KFileDnDIconView(parent,name),
		m_connection( c ),m_privateActionCollection( new KActionCollection( 0L, this, "IconViewActionCollection" ))
{
	setViewName( i18n("Short View") );
	setViewMode( KFileView::All );
	setupActions();
	readConfig( kapp->config(), "View Settings" );
	setSelectionMode( KFile::Extended );
	setGridX( 85 );
//	setFocusPolicy( QWidget::WheelFocus );
	bool ok;
	m_codec = KGlobal::charsets()->codecForName( m_connection.fileSysEncoding(), ok );
}
//-----------------------------------------------
KBearIconView::~KBearIconView(){
}
//-----------------------------------------------
void KBearIconView::setupActions(){
	new KActionSeparator( m_privateActionCollection, "separator" );
	KToggleAction* action;
	action = new KToggleAction( i18n("Text at the &bottom"), 0,
						this, SLOT( slotTextBottom() ), m_privateActionCollection, "bottom text"  );
	action->setChecked( true );
	action->setExclusiveGroup( "icon text pos" );

	action = new KToggleAction( i18n("Text at the &right"), 0,
						this, SLOT( slotTextRight() ), m_privateActionCollection, "right text"  );
	action->setChecked( false );
	action->setExclusiveGroup( "icon text pos" );

	action = new KToggleAction( i18n("Arrange l&eft to right"), 0,
						this, SLOT( slotFlowEast() ), m_privateActionCollection, "left to right"  );
	action->setChecked( true );
	action->setExclusiveGroup( "icon flow" );

	action = new KToggleAction( i18n("Arrange t&op to bottom"), 0,
						this, SLOT( slotFlowSouth() ), m_privateActionCollection, "top to bottom"  );
 	action->setChecked( false );
	action->setExclusiveGroup( "icon flow" );

	action = new KToggleAction( m_privateActionCollection, "wordwrap text"  );
	action->setText( i18n("&Wordwrap item text") );
	action->setChecked( false );
	connect( action, SIGNAL( toggled ( bool ) ), this, SLOT( slotTextWordWrap( bool ) ) );

	KActionMenu* menu = new KActionMenu( i18n("Icon View Settings"), actionCollection(), "icon view menu");
	menu->insert( m_privateActionCollection->action("small columns") );
	menu->insert( m_privateActionCollection->action("large rows") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("bottom text") );
	menu->insert( m_privateActionCollection->action("right text") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("left to right") );
	menu->insert( m_privateActionCollection->action("top to bottom") );
	menu->insert( m_privateActionCollection->action("separator") );
	menu->insert( m_privateActionCollection->action("wordwrap text") );

}
//-----------------------------------------------
void KBearIconView::readConfig( KConfig* config, const QString& group ) {
	// Have to do this in order to have LargeRows as default
	KConfigGroupSaver cs( config, group );
	QString mode = config->readEntry("ViewMode", QString::fromLatin1("LargeRows") );
	config->writeEntry("ViewMode", mode );
	KFileDnDIconView::readConfig( config, group );
}
//-----------------------------------------------
void KBearIconView::writeConfig( KConfig* config, const QString& group ) {
	KFileDnDIconView::writeConfig( config, group );
}
//-----------------------------------------------
void KBearIconView::setItemTextPos( QIconView::ItemTextPos ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("bottom text"))->isChecked() )
		QIconView::setItemTextPos( QIconView::Bottom );
	else
		QIconView::setItemTextPos( QIconView::Right );
}
//-----------------------------------------------
void KBearIconView::setArrangement( QIconView::Arrangement ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("left to right"))->isChecked() )
		QIconView::setArrangement( QIconView::LeftToRight );
	else
		QIconView::setArrangement( QIconView::TopToBottom );
}
//-----------------------------------------------
void KBearIconView::setWordWrapIconText( bool ) {
	if( static_cast<KToggleAction*>(m_privateActionCollection->action("wordwrap text"))->isChecked() )
		QIconView::setWordWrapIconText( true );
	else	
		QIconView::setWordWrapIconText( false );
}
//-----------------------------------------------
void KBearIconView::slotTextBottom(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("bottom text"));
	action->setChecked( true );
	setItemTextPos( QIconView::Bottom );
}
//-----------------------------------------------
void KBearIconView::slotTextRight(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("right text"));
	action->setChecked( true );
	setItemTextPos( QIconView::Right );
}
//-----------------------------------------------
void KBearIconView::slotFlowEast(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("left to right"));
	action->setChecked( true );
	setHScrollBarMode( QIconView::AlwaysOff );
	setVScrollBarMode( QIconView::Auto );
	setArrangement( QIconView::LeftToRight );
}
//-----------------------------------------------
void KBearIconView::slotFlowSouth(){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("top to bottom"));
	action->setChecked( true );
	setVScrollBarMode( QIconView::AlwaysOff );
	setHScrollBarMode( QIconView::Auto );
	setArrangement( QIconView::TopToBottom );
}
//-----------------------------------------------
void KBearIconView::slotTextWordWrap( bool wrap ){
	KToggleAction* action = static_cast<KToggleAction*>(m_privateActionCollection->action("wordwrap text"));
	action->setChecked( wrap );
	setWordWrapIconText( wrap );
}
//-----------------------------------------------
QDragObject* KBearIconView::dragObject() {
	// create a list of the URL:s that we want to drag
	KURL::List urls;
	KFileItemListIterator it( * KFileView::selectedItems() );
	for ( ; it.current(); ++it ){
		urls.append( (*it)->url() );
	}
	QPixmap pixmap;
	if( urls.count() > 1 )
		pixmap = DesktopIcon( "kmultiple", iconSize() );
	if( pixmap.isNull() )
		pixmap = currentFileItem()->pixmap( iconSize() );	
	QPoint hotspot;
	hotspot.setX( pixmap.width() / 2 );
	hotspot.setY( pixmap.height() / 2 );
	QMap<QString,QString> meta = m_connection.metaData();
     meta.insert( "sourceName", m_connection.label().utf8() );
	KURLDrag* myDragObject = KURLDrag::newDrag( urls, meta, widget() );

	myDragObject->setPixmap( pixmap, hotspot );
	return myDragObject;
}
//-----------------------------------------------
void KBearIconView::insertItem( KFileItem *inf ) {
	KFileIconView::insertItem( inf );
	KFileIconViewItem *item = (KFileIconViewItem*) inf->extraData( this );
	if( !item )
		return;

	if( m_connection.isLocal() )
		item->setText( inf->text() );
	else
		item->setText( m_codec->toUnicode( inf->text() ) );
}
//-----------------------------------------------
void KBearIconView::updateView( const KFileItem* inf ) {
	if( !inf )
		return;


	KFileIconView::updateView( inf );
	KFileIconViewItem *item = (KFileIconViewItem*) inf->extraData( this );
	if( !item )
		return;

	if( m_connection.isLocal() )
		item->setText( inf->text() );
	else
		item->setText( m_codec->toUnicode( inf->text() ) );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeariconview.moc"
#endif
