/***************************************************************************
                          kbearmdichildview.cpp  -  description
                             -------------------
    begin                : tis jan 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qlayout.h>
#include <qcursor.h>
#include <qevent.h>
#include <qtextcodec.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
#include <klibloader.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kaction.h>
#include <klocale.h>
#include <kurldrag.h>
#include <kstatusbar.h>
#include <kparts/part.h>
#include <kparts/componentfactory.h>
#include <kmessagebox.h>

#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearmdichildview.h"
#include "kbear.h"
#include "base/transfer.h"
#include "base/kbearchildviewpart.h"
#include "resource.h"

#include <X11/Xlib.h>

//-----------------------------------------------
KBearMdiChildView::KBearMdiChildView( QWidget *parent, const Connection& c )
	:	QextMdiChildView(c.label(),parent,c.label()),
		DCOPObject( c.label().latin1() ),
		m_part( 0L )
{
	new QVBoxLayout( this );
	if( ! kapp->dcopClient()->isRegistered() ) {
		kapp->dcopClient()->attach();
		kapp->dcopClient()->registerAs( PACKAGE );
	}
	setObjId( c.label().latin1() );
	setMDICaption( c.label() );
	resolveConnection( c );
	setFocusPolicy( QWidget::WheelFocus );
	readProperties( kapp->config(), "View Settings" );
}
//-----------------------------------------------
KBearMdiChildView::~KBearMdiChildView(){
	kdDebug()<<"KBearMdiChildView::~KBearMdiChildView()="<<this<<endl;
	if( m_part ) {
		delete m_part;
	}
//	KBear::self()->partManager()->removeManagedTopLevelWidget( this );
}
//-----------------------------------------------
Connection KBearMdiChildView::connection() const {
	return m_part->connection();
}
//-----------------------------------------------
void KBearMdiChildView::closeEvent(QCloseEvent *e) {
	if( m_part && m_part->disconnect() )
		QextMdiChildView::closeEvent( e );
}
//-----------------------------------------------
void KBearMdiChildView::focusInEvent( QFocusEvent* e ) {
	QextMdiChildView::focusInEvent( e );
	if( e && (e->reason() != QFocusEvent::Popup) ) {
		if( m_part->viewer() ) {
//			QApplication::sendEvent( m_part->viewer()->widget(), new QFocusEvent( (QEvent::Type)8 ) );
kdDebug()<<"KBearMdiChildView::focusInEvent( Viewer"<<endl;
			KBear::self()->partManager()->setActivePart( m_part->viewer() );
		}
		else {
//			QApplication::sendEvent( m_part->widget(), new QFocusEvent( (QEvent::Type)8 ) );
			KBear::self()->partManager()->setActivePart( m_part );
		}
	}
}
//-----------------------------------------------
void KBearMdiChildView::resolveConnection( const Connection& connection ){
//Here we have to resolve which part to use

//	m_part = new KBearFileSysPart( this, "KBearChildViewPartWidget", KBear::self(), "KBearFileSysPart" );

	m_part = KParts::ComponentFactory::createPartInstanceFromLibrary
									<KBearChildViewPart>("libkbearfilesyspart",
									this, "KBearChildViewPartWidget", KBear::self(), "KBearFileSysPart" );

	if( m_part ) {
		layout()->add( m_part->widget() );
//		setFirstFocusableChildWidget( m_part->widget() );
		setupConnections();
		m_part->openConnection( connection );
		KBear::self()->partManager()->addPart( m_part );
//		KBear::self()->partManager()->addManagedTopLevelWidget( this );
	}
	else {
		kdFatal() << "No KBearFileSysPart found !!!!!!!!!!!!!!!!!!!!!" << endl;
	}
}
//-----------------------------------------------
void KBearMdiChildView::setPath( QString path ) {
	KURL url = connection().url();
	url.setPath( path );
	m_part->openURL( url );
}
//-----------------------------------------------
void KBearMdiChildView::reload() {
	m_part->reload();
}
//-----------------------------------------------
void KBearMdiChildView::home() {
	m_part->home();
}
//-----------------------------------------------
void KBearMdiChildView::cdUp() {
	m_part->cdUp();
}
//-----------------------------------------------
void KBearMdiChildView::back() {
	m_part->back();
}
//-----------------------------------------------
void KBearMdiChildView::forward() {
	m_part->forward();
}
//-----------------------------------------------
void KBearMdiChildView::stop() {
	m_part->stop();
}
//-----------------------------------------------
QString KBearMdiChildView::currentURL() const {
	return m_part->url().url();
}
//-----------------------------------------------
KURL KBearMdiChildView::currentDir() const {
	return m_part->currentDir();
}
//-----------------------------------------------
void KBearMdiChildView::readProperties( KConfig* config, const QString& group ) {
     m_part->readProperties( config, group );
}
//-----------------------------------------------
void KBearMdiChildView::saveProperties( KConfig* config, const QString& group ) {
     m_part->saveProperties( config, group );
}
//-----------------------------------------------
void KBearMdiChildView::slotLogMessage( const QString& message ) {
	emit logMessage( connection().label(), message );
}
//-----------------------------------------------
void KBearMdiChildView::slotDropped( QMimeSource* drag, const QPoint& pos ) {
	if( ! QUriDrag::canDecode( drag ) )
		return;

	QPopupMenu menu( this );
	int action;
	const int COPY = menu.insertItem( i18n("&Copy") );
	const int MOVE = menu.insertItem( i18n( "&Move" ) );
/*
	menu.insertSeparator();
	const int LINK = menu.insertItem( i18n( "&Link" ) );
*/
	// Check the state of the modifiers key at the time of the drop
	Window root;
	Window child;
	int root_x, root_y, win_x, win_y;
	uint keybstate;
	XQueryPointer( qt_xdisplay(), qt_xrootwin(), &root, &child, &root_x, &root_y, &win_x, &win_y, &keybstate );

/*
	if( keybstate & ControlMask && keybstate & ShiftMask ) {
		action = LINK;
	}
	else */if( keybstate & ControlMask ) {
		action = COPY;
	}
	else if( keybstate & ShiftMask ) {
		action = MOVE;
	}
	else {
		menu.setMouseTracking( TRUE );
		action = menu.exec( pos );
	}
	KIO::MetaData sourceMeta;
	KURL::List urls;
	KURLDrag::decode( drag, urls, sourceMeta );
	if( action == COPY ) {
		sourceMeta.insert("action", "copy" );
	}
	else if( action == MOVE ) {
		sourceMeta.insert("action", "move" );
	}
	else
		return;

	newTransfer( sourceMeta, urls );
}
//-----------------------------------------------
KURL::List KBearMdiChildView::selectedURLs() {
	return m_part->selectedURLs();
}
//-----------------------------------------------
void KBearMdiChildView::setupConnections(){
	connect( m_part, SIGNAL( setStatusBarText( const QString& ) ),
				KBear::self()->statusBar(), SLOT( message( const QString& ) ) );
	connect( m_part, SIGNAL( setWindowCaption( const QString& ) ),
				this, SLOT( slotSetCaption( const QString& ) ) );
	connect( m_part, SIGNAL( transfer( KURLDrag* ) ),
				this, SLOT( slotNewTransfer( KURLDrag* ) ) );
	connect( m_part, SIGNAL( logMessage( const QString& ) ) ,
				this, SLOT( slotLogMessage( const QString& ) ) );
	connect( m_part, SIGNAL( dropped( QMimeSource*, const QPoint& ) ) ,
				this, SLOT( slotDropped( QMimeSource*, const QPoint& ) ) );
	connect( m_part, SIGNAL( closeMe() ), this, SLOT( emitCloseRequest() ) );
}
//-----------------------------------------------
void KBearMdiChildView:: emitCloseRequest() {
	emit childWindowCloseRequest( this );
}
//-----------------------------------------------
bool KBearMdiChildView::isLocal() const {
	return ! m_part->url().hasHost();
}
//-----------------------------------------------
void KBearMdiChildView::showToolBarUpper( bool show ) {
	m_part->showToolBarUpper( show );
}
//-----------------------------------------------
void KBearMdiChildView::showToolBarLower( bool show ) {
	m_part->showToolBarLower( show );
}
//-----------------------------------------------
void KBearMdiChildView::showStatusBarUpper( bool show ) {
	m_part->showStatusBarUpper( show );
}
//-----------------------------------------------
void KBearMdiChildView::showStatusBarLower( bool show ) {
	m_part->showStatusBarLower( show );
}
//-----------------------------------------------
QPopupMenu* KBearMdiChildView::popupMenu() {
	return m_part->popupMenu();
}
//-----------------------------------------------
void KBearMdiChildView::slotSetCaption( const QString& caption ) {
	setCaption( tabCaption() +" - " + caption );
}
//-----------------------------------------------
void KBearMdiChildView::newTransfer( KIO::MetaData sourceMeta, const KURL::List& urls ) {
	//Here we creates a Transfer object to emit
	Transfer* trans = new Transfer;

	trans->sourceList() = urls;

	if( sourceMeta.contains("action") )
		trans->setMove( (sourceMeta["action"] == "move") );
	else {
		sourceMeta.insert( "action", "copy" );
		trans->setMove( false );
	}
	Connection sourceC( trans->sourceList().first() );
	if( ! sourceMeta.contains("sourceName") || sourceMeta["sourceName"] == QString::null )
		sourceMeta.insert( "sourceName", sourceC.host().utf8() );

	sourceC.setLabel( QString::fromUtf8( sourceMeta["sourceName"]) );

	sourceC.setMetaData( sourceMeta );
	trans->setSourceConnection( sourceC );
	trans->setDestConnection( connection() );
	trans->setDestURL( currentDir() );

	emit transfer( trans );
}
//-----------------------------------------------
void KBearMdiChildView::slotNewTransfer( KURLDrag* data ) {
	kdDebug()<<"KBearMdiChildView::slotNewTransfer()"<<endl;
	// First fetch the received information
	KIO::MetaData sourceMeta;
	KURL::List urls;
	KURLDrag::decode( data, urls, sourceMeta );
	delete data; //we have to delete it ourself
	newTransfer( sourceMeta, urls );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearmdichildview.moc"
#endif
