/***************************************************************************
                          site.h  -  description
                             -------------------
    begin                : sn jan 6 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITE_H
#define SITE_H

//////////////////////////////////////////////////////
// Qt specific includes
//////////////////////////////////////////////////////
// KDE specific includes
//////////////////////////////////////////////////////
// Application specific includes
#include "../base/connection.h"

/**
  *@author Bjrn Sahlstrm
  */

class Site : public Connection  {
public: 
	/** */
	Site();
	/** */
	Site( const Connection& c );
	/**
	*@returns parent group for this site or @ref QString::null if none
	*/
	QString parent() const { return m_parent; }
	/**
	*@returns description for this site
	*/
	QString description() const { return m_description; }
	/** Set parent for this site */
	void setParent( const QString& p ) { m_parent = p; }
	/** Set description for this site */
	void setDescription( const QString& d ) { m_description = d; }
	/** @returns a @ref Connection representing the site */
	Connection connection() const { return *this; }
	/** */
	void insert( QDataStream& out ) const;
	/** */
	void extract( QDataStream& in );
	/** */
protected:
	/** name of the sites parent in the SiteManager */
	QString m_parent;
	/** A short description for the site */
	QString m_description;
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const Site& site ) {
	site.insert( s );
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, Site& site ) {
	site.extract( s );
	return s;
}
#endif
