/***************************************************************************
                          kbearclipboard.h  -  description
                             -------------------
    begin                : Fri Jul 14 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCLIPBOARD_H
#define KBEARCLIPBOARD_H
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstringlist.h>
#include <qdragobject.h>
#include <qclipboard.h>
#include <qapplication.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfileview.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files

/**
	* This object holds the contents of the clipboard, e.g. all URL:s that are cut or copied.
	*Whenever a new cut or copy is made the old contents is overwritten.
	*After a paste operation the contents is also cleared.
	*
	*@author Bjrn Sahlstrm
*/
class KBearClipBoard {
public:
	KBearClipBoard();
	~KBearClipBoard();
	/**
	*Clears the internal clipboard from it's contents
	*@see KBearClipBoard#isEmpty
	*/
	void clear();
	/**
	*@returns a pointer to a @ref KURL::List that contains all URL:s in the clipboard
	*/
	KURL::List clipBoardContents();
	/**
	*@param list clears the old contents and sets the clipboard contents to be list
	*/
	void setContents( const KURL::List& list, QWidget* );
	/**
	*@returns true if the contents is filled by a cut operation.( mostly for internal use)
	*/
	bool cut() const { return b_isCut; }
	/**
	*@see KBearClipBoard#clear
	*@returns true if clipboard is empty
	*/
	bool isEmpty() const { return b_isEmpty; }
	/**  */
	void setCut( bool cut );
		
private://Private attributes
	bool b_isCut;
	bool b_isEmpty;
};

#endif
