#ifndef _SQLITE_INTER_H // -*-C++-*-
#define _SQLITE_INTER_H

// Glue functions for talking to libsqlite3

#include <stdfuns.h>
#include <KayaAPI.h>
#include <sqlite3.h>

using namespace std;

class SQLiteConnection : public gc {
public:
    sqlite3* db;
    int ok;
};

class SQLiteResult : public gc {
public:
    KArray res_table;
    KArray col_names;
    int rows;
    int cols;
    int res;
};

extern "C" {
    void* sqlite_connect(wchar_t* info);
    int sqlite_ok(void* con);
    wchar_t* sqlite_getError(void* con);
    void sqlite_close(void* con);
    void* sqlite_exec(void* con, wchar_t* query);

    KArray sql_getcolnames(void* res);
    KArray sql_getrestable(void* res);
    int sql_numrows(void* res);
    int sql_numcols(void* res);
    int sql_resrc(void* res);
}

#endif
