#ifndef _CURSES_GLUE_H
#define _CURSES_GLUE_H

#include <KayaAPI.h>
#include <curses.h>

#define DECLKEY(x) wchar_t key_## x();
#define DEFKEY(x) wchar_t key_## x() { return KCHAR(KEY_## x); }
#define DECLKEYF(x) wchar_t key_F## x();
#define DEFKEYF(x) wchar_t key_F## x() { return KCHAR(KEY_F(x)); }

extern "C" {
    bool testerr(int x);

    void docbreak();
    void donocbreak();
    void doecho();
    void donoecho();
    void donl();
    void dononl();
    void doraw();
    void donoraw();

    WINDOW* getstdscr();
    void dointrflush(void* v, bool bf);
    void dokeypad(void* v, bool bf);
    void dometa(void* v, bool bf);
    void donodelay(void* v, bool bf);
    void donotimeout(void* v, bool bf);

    void dorefresh();
    void dowrefresh(void* win);

    void dowmove(void* w, int y, int x);
    void domove(int y, int x);

    wchar_t dogetch();
    wchar_t domvgetch(int x, int y);
    wchar_t dowgetch(void* win);
    wchar_t dowmvgetch(void* win, int x, int y);

    wchar_t* dogetstr();
    wchar_t* dowgetstr(void* win);

    void doaddstr(wchar_t * s);
    void dowaddstr(void* w, wchar_t * s);

    int doattron(KayaArray attribs);
    int doattroff(KayaArray attribs);
    int dowattron(void* w,KayaArray attribs);
    int dowattroff(void* w,KayaArray attribs);

    int getBlack();
    int getRed();
    int getGreen();
    int getYellow();
    int getBlue();
    int getMagenta();
    int getCyan();
    int getWhite();
    int getColourPairs();
    int getColours();

    void* donewwin(int l, int c,int y, int x);
    int dodelwin(void* win);
    int domvwin(void* win, int y, int x);

    DECLKEY(DOWN);
    DECLKEY(UP);
    DECLKEY(LEFT);
    DECLKEY(RIGHT);
    DECLKEY(HOME);
    DECLKEY(END);
    DECLKEY(BACKSPACE);
    DECLKEY(A1);
    DECLKEY(A3);
    DECLKEY(B2);
    DECLKEY(C1);
    DECLKEY(C3);

    DECLKEYF(1);
    DECLKEYF(2);
    DECLKEYF(3);
    DECLKEYF(4);
    DECLKEYF(5);
    DECLKEYF(6);
    DECLKEYF(7);
    DECLKEYF(8);

    int dobox(void* win,wchar_t x, wchar_t y);

    void doclear();
    void doerase();
    void doclrtobot();
    void doclrtoeol();
    void dowclear(void* p);
    void dowerase(void* p);
    void dowclrtobot(void* p);
    void dowclrtoeol(void* p);
}

#endif
