/***************************************************************************
                          parser.yy  -  description
                             -------------------
    begin                : Wed Jul 5 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

%{
#include <stdlib.h>
#include <iostream.h>
#include <qlist.h>
#include <qstring.h>
#include "kgrammar.h"
#include "krule.h"

int yylex();
int yyerror(char *);
extern int yylineno;
extern bool verbose_flag;
extern KGrammar *gr;
%}


%union
{
  int integer;
  QString * string;
  QString * strings[3];
  QList<param_type> * list;
  param_type * scalar;
  KRule * pRule;
}

%token <integer> INT ARROW TO SPECIAL MODIFIER LARROW

%token <string> WORD STRING REGEX
%token <strings> SUBSTITUTION TRANSLATION

%type <integer> start;
%type <integer> rules;
%type <integer> rule;
%type <pRule> special;
%type <strings> comment
%type <integer> modifiers;
%type <list> paramlist;
%type <list> parameters;
%type <scalar> param;
%type <scalar> initvalue;
%type <pRule> conjunction;
%type <pRule> disjunction;
%type <integer> description;
%type <integer> semicolon;
//%type <integer> equsign;
%type <integer> constraint;
%type <list> transformations;


%%
start:  rules { $$=0 } ;

rules:  /* epsilon */
        { $$=0; }
      | rules rule
        { $$=0; }
      | rules description
        { $$=0; }
      | rules constraint
        { $$=0; }

rule:   WORD modifiers comment ARROW transformations disjunction ';'
          {
            KRule *old=gr->getRule(gr->storeNonterminal($1));
            $6->left=gr->storeNonterminal($1);
            $6->setTitle($3[0]);delete $3[0];
            $6->setToolTip($3[1]);delete $3[1];
            $6->setWhatsThis($3[2]);delete $3[2];
            $6->style=$2;
            $6->transformers=$5;
            if (old)
              old->addAsNewClause($6);
            else
              gr->addRule($6);
            $$=0;
          }

transformations:
                  {
                    $$=new QList<param_type>;
                  }
                  | transformations SUBSTITUTION
                  {
                    param_type * trans=new param_type;
                    trans->type=4;
                    trans->strsData=$2;
                    $1->append(trans);
                    $$=$1;
                  }
                  | transformations TRANSLATION
                  {
                    param_type * trans=new param_type;
                    trans->type=5;
                    trans->strsData=$2;
                    $1->append(trans);
                    $$=$1;
                  }

description: WORD modifiers '=' comment semicolon
            {
              if (verbose_flag)
              {
                if ($1)    cout << *$1 << " = \"";
                if (!($4[0]->isEmpty())) cout << *($4[0]);
                cout << "\" \"";
                if (!($4[1]->isEmpty())) cout << *($4[1]);
                cout << "\" \"";
                if (!($4[2]->isEmpty())) cout << *($4[2]);
                cout << "\" ;" << endl;
              }
              if (gr->isNonterminal($1) && gr->getRule(gr->storeNonterminal($1)))
              {
                KRule * rule=gr->getRule(gr->storeNonterminal($1));
                if (!($4[0]->isEmpty())) rule->setTitle($4[0]); delete $4[0];
                if (!($4[1]->isEmpty())) rule->setToolTip($4[1]); delete $4[1];
                if (!($4[2]->isEmpty())) rule->setWhatsThis($4[2]); delete $4[2];
                rule->style|=$2;
              }
              else
                cerr << "Rule for `" << *$1 << "' must preceed its description." << endl;
              $$=0;
            }

semicolon: { $$=0; } | ';' { $$=1; }
//equsign: { $$=0; } | '=' { $$=1; }

comment:  /* epsilon */
          {
            $$[0]=new QString();
            $$[1]=new QString();
            $$[2]=new QString();
          }
          | STRING
          {
            $$[0]=$1;
            $$[1]=new QString();
            $$[2]=new QString();
          }
          | STRING STRING
          {
            $$[0]=$1;
            $$[1]=$2;
            $$[2]=new QString();
          }
          | STRING STRING STRING
          {
            $$[0]=$1;
            $$[1]=$2;
            $$[2]=$3;
          }

modifiers:  /* epsilon */
            { $$ = 0; }
          | modifiers MODIFIER
            { $$ = $1|$2; }


disjunction:  conjunction
              {
                $$=$1;
              }
            | disjunction '|' conjunction
              {
                $1->addAsNewClause($3);
                $$=$1;
              }

conjunction:  /* epsilon */
              {
                $$=new KRule();
              }
            | conjunction WORD
              {
                $1->append(gr->storeNonterminal($2));
              }
            | conjunction STRING
              {
                $1->append(gr->storeTerminal($2));
              }
            | conjunction '@'
              {
                $$=$1;
              }
            | conjunction '!'
              {
                $1->setDefault();
                $$=$1;
              }
            | conjunction special
              {
                if ($1->rightSide().count()==0 && !($1->isSpecial()))
                  $$=$2;
                else
                {
                  int i=gr->getNewNonterminal();
                  $1->append(i);
                  $2->left=i;
                  gr->addRule($2);
                  $$=$1;
                }
              }

special:  SPECIAL parameters initvalue
          {
             $$=new KRule();
             $$->setSpecial($1);
             $$->setParams($2);
             $$->setInitValue($3);
          }

parameters: /* epsilon */
            {
              $$=0;
            }
          | '(' paramlist ')'
            {
              $$=$2;
            }

paramlist:  /* epsilon */
            {
              $$=0;
            }
            | param
            {
              $$=new QList<param_type>;
              $$->append($1);
            }
            | paramlist ',' param
            {
              if ($1) { $1->append($3); $$=$1; }
              else $$=new QList<param_type>;
            }

param: INT
       {
        $$=new param_type;
        $$->type=1;
        $$->intData=$1;
       }
     | WORD
       {
        $$=new param_type;
        $$->type=2;
        $$->intData=gr->storeNonterminal($1);
       }
     | STRING
       {
        $$=new param_type;
        $$->type=0;
        $$->strData=$1;
       }
     | REGEX
       {
        $$=new param_type;
        $$->type=3;
        $$->strData=$1;
       }
     | SUBSTITUTION
       {
        $$=new param_type;
        $$->type=4;
        $$->strsData=$1;
       }
     | TRANSLATION
       {
        $$=new param_type;
        $$->type=5;
        $$->strsData=$1;
       }


initvalue: /* epsilon */
           {
             $$=0;
           }
         | '=' param
           {
             $$=$2;
           }

constraint: WORD LARROW WORD semicolon
            {
              if (gr->isNonterminal($1) && gr->isNonterminal($3))
              {
                KRule * rule1, * rule2;
                rule1=gr->getRule(gr->storeNonterminal($1));
                rule2=gr->getRule(gr->storeNonterminal($3));
                if (rule1 && rule2)
                {
                  if (rule1->isDisjunctive() && rule2->isDisjunctive()
                      && rule1->children().count()==rule2->children().count())
                    rule1->setConstraint(rule2);
                  else
                    cerr << "Rules `" << $1 << "' and `" << $3 << "' have different number of right side choices."
                         << endl << "Can't make constraint." << endl;
                }
              } else
                cerr << "Rule definition must preceed constraint " << $1 << " <- " << $3 << endl;
              $$=0;
            }

%%

int yyerror(char * s)
{
  cerr << "Parse error. " << endl;
  if (!verbose_flag) cerr << "Use flag --verbose or -V to see which was the last correct rule" << endl;
  return 0;
}