/***************************************************************************
                          kplace.cpp  -  description
                             -------------------
    begin                : Tue Aug 8 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kplace.h"

#include <qstring.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qpixmap.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qlistview.h>
#include <qheader.h>
#include <qtextview.h>

#ifdef HAVE_KDE
//  #include <ktabctl.h> ktabctl does no resize to the appropriate widget size
//    #define QTabWidget KTabCtl
  #include <kiconloader.h>
  #include <kfiledialog.h>
  #include <kprocess.h>
  #include <kapp.h>
#else // QT_ONLY
  #include <qfiledialog.h>
  #include "kmyprocess.h"
  #include <qapplication.h>
  #define KFileDialog QFileDialog
#endif // HAVE_KDE

#include "qregvalidator.h"
#include "krule.h"
#include "kgrammar.h"
#include "kaptain.h"
#include "kaptainwizard.h"
#include "kexecutor.h"

#include <iostream.h>
#include <stdlib.h>

extern KGrammar * gr;
extern bool test_flag;

int NUM_STACK_MEMBERS; // count how many widgets are inserted into the stack
                       // when building a tree

QPixmap loadPixmap(QString name, int n)
{
  QPixmap icon;
  if (!(icon.load(name)));
  {
    if (!(icon.load(QString(getenv("PWD"))+"/"+name)))
    {
#ifdef HAVE_KDE
      KIconLoader loader;
      icon=loader.loadIcon(name,n);
#endif // HAVE_KDE
    }
  }
  return icon;
}

KPlace::KPlace(KRule * rp, bool needTitle, bool needFrame, bool needRadio,
               bool needCheck, bool needTristate,
               QWidget * parentWidget, QBoxLayout * parentLayout,
               QObject * parent, QDialog * parentDialog, bool noPushButton=false,
               bool noTree=false)
  : QObject(parent, gr->getNonterminal(rp->leftSide()))
{
  QTabWidget * tabWidget=0;
  myDialog=parentDialog;

  clearAttributes();

  rule=rp;
  rule->setPlace(this);

  /* create a frame  */
  if (needFrame)
  {
    QGroupBox * frame = new QGroupBox(-1, Vertical, rule->getTitle(), parentWidget);
    int frameSize=2*frame->lineWidth() + frame->midLineWidth() + frame->margin();
    parentLayout->addWidget(frame);
    QBoxLayout * childLayout=new QVBoxLayout(frame, frameSize+5, SPACING);
    childLayout->addSpacing(frame->fontMetrics().height()-frameSize);

//    parentLayout->addLayout(childLayout);
    parentLayout=childLayout;
//    if (rule->isBeside())
//      parentLayout->setDirection(QBoxLayout::LeftToRight);
    parentWidget=frame;
    needTitle=false;
  }
  /* or else a new vertical box layout if not ordered to align widgets just beside the title*/
  else
    if (!(rule->isBeside()))
      parentLayout=new QVBoxLayout(parentLayout, SPACING);
    else
      parentLayout=new QHBoxLayout(parentLayout, SPACING);

  /* Do we need a radiobutton at the top of this place */
  if (needRadio)
  {
    radio=new QRadioButton(rule->getTitle(), parentWidget);
    connect(radio, SIGNAL(clicked()), SLOT(selected()));
    parentLayout->addWidget(radio);
    needTitle=false;
    /* ToolTip support */
    if (!(rule->getToolTip().isEmpty()))
      QToolTip::add(radio, rule->getToolTip());
    /* WhatsThis support */
    if (!(rule->getWhatsThis().isEmpty()))
      QWhatsThis::add(radio, rule->getWhatsThis());
  }

  /* Do we need a checkbox at the top of this place */
  if (needCheck || needTristate)
  {
    check=new QCheckBox(rule->getTitle(), parentWidget);
    if (needTristate) check->setTristate();
    parentLayout->addWidget(check);
    needTitle=false;
    /* ToolTip support */
    if (!(rule->getToolTip().isEmpty()))
      QToolTip::add(check, rule->getToolTip());
    /* WhatsThis support */
    if (!(rule->getWhatsThis().isEmpty()))
      QWhatsThis::add(check, rule->getWhatsThis());
  }

  /* make indention if check or radio is present */
  if ((needCheck || needRadio || needTristate) && !(rule->isBeside()))
  {
    QBoxLayout * indent = new QHBoxLayout(parentLayout);
    indent->addSpacing(parentWidget->fontMetrics().height()+SPACING);
    parentLayout=indent;
  }

  /* create tab widget if neeeded */
  if (rule->isTabbed())
  {
    tabWidget=new QTabWidget(parentWidget);
    parentLayout->addWidget(tabWidget);
  }

  if (needTitle && !(rule->getTitle().isEmpty()) && !(rule->isWizard() || rule->isDialog()) )
  {
    QLabel * text=new QLabel(rule->getTitle(),parentWidget);
    parentLayout->addWidget(text);
    if (!(rule->getToolTip().isEmpty()))
      QToolTip::add(text, rule->getToolTip());
  }

  if (rule->isSpecial())
  {
    QWidget * special=makeSpecial(rule, parentWidget, parentLayout);
    if (rule->getSpecType()==0) /* @integers to the left, if :beside then to the right */
      parentLayout->addWidget(special, 0, rule->getAlign());
    else
      parentLayout->addWidget(special);
    /* ToolTip support */
    if (!(rule->getToolTip().isEmpty()))
      QToolTip::add(special, rule->getToolTip());
    /* WhatsThis support */
    if (!(rule->getWhatsThis().isEmpty()))
      QWhatsThis::add(special, rule->getWhatsThis());
  }
  else
  /* if a button should be placed */
  if ((rule->isWizard() || rule->isDialog()) && !noPushButton)
  {
    pushButton=new QPushButton(parentWidget);
    parentLayout->addWidget(pushButton);
    /* set button text */
    if (rule->getTitle()) pushButton->setText(rule->getTitle());
    buttonchild=rule;
    pW=parentWidget;
    connect(pushButton, SIGNAL(clicked()), SLOT(invokeChild()));
    pushButton->setFixedSize(pushButton->sizeHint());
  } else
  /* tree/list view with a widget stack */
  if (rule->isTree() && (rule->isConjunctive() || rule->isDisjunctive()) && !noTree)
  {
    myDict=new QPtrDict<KPlace>;
    listView=new QListView(parentWidget);
    stack=new QWidgetStack(parentWidget);NUM_STACK_MEMBERS=0;
    parentLayout->addWidget(listView);
    listView->setRootIsDecorated(true);
    if (rule->isDetailed()) {
      listView->addColumn("");
      listView->addColumn("");
//      listView->header()->hide();
    } else {
      listView->addColumn("");
      listView->header()->hide();
    }
    listView->setSorting(-1);
    // what if NOT ???????????
    bool father=rule->isDisjunctive() && !(rule->isCheckBox());
    if (father)
    {
      item=new QCheckListItem(listView, rule->getTitle(), QCheckListItem::Controller);
      myDict->insert(item, this);
    }
    QValueList<int> children=rule->children();
    QValueList<int>::Iterator ch;
    QListViewItem * lastItem=0;
    int n=1, def=rule->getDefault();
    for (ch=children.begin(); ch!=children.end(); ++ch, ++n)
    {
      KRule * child=gr->getRule(*ch);
      KPlace * childPlace=new KPlace(child, stack, listView, item, rule, lastItem, myDict);
      if (n==def && father) ((QCheckListItem *)(childPlace->item))->setOn(true);
      lastItem=childPlace->item;
      subPlaces.append(childPlace);
    }
    listView->adjustSize();
    if (NUM_STACK_MEMBERS)
      parentLayout->addWidget(stack,1);
    else // hide the widget stack
      stack->hide();
//    stack->setMinimumSize(stack->sizeHint());
    connect(listView,SIGNAL(currentChanged(QListViewItem *)),SLOT(pageSelected(QListViewItem *)));
  }
  else
  /***************************/
  /* Multiple KPlaces inside */
  /***************************/
  if (rule->isDisjunctive() || rule->isConjunctive())
  {
    bool subNeedCheck=   !(rule->hasBoss()) && rule->isCheckBox();
    bool subNeedTristate=!(rule->hasBoss()) && rule->isTristate();
    bool subNeedRadio=   !(rule->hasBoss()) && rule->isDisjunctive()
                           && !subNeedCheck && !subNeedTristate;
    bool subFramed=rule->isFramed();

    QBoxLayout * childLayout, * parentLayouts[2];
    /* two rows or columns of fields in layouts */
    if (rule->isDouble() && !(rule->isTabbed()) )
    {
      if (rule->isHorizontal())
        parentLayout=new QBoxLayout(parentLayout, QBoxLayout::TopToBottom); else
        parentLayout=new QBoxLayout(parentLayout, QBoxLayout::LeftToRight);

      QBoxLayout::Direction d;
      if (rule->isHorizontal())
        if (rule->isReverse())
          d=QBoxLayout::RightToLeft; else
          d=QBoxLayout::LeftToRight;
      else
        if (rule->isReverse())
          d=QBoxLayout::BottomToTop; else
          d=QBoxLayout::TopToBottom;

      if (rule->isReverse())
      {
        parentLayouts[0]=new QBoxLayout(parentLayout, d);
        parentLayouts[1]=new QBoxLayout(parentLayout, d);
      } else
      {
        parentLayouts[1]=new QBoxLayout(parentLayout, d);
        parentLayouts[0]=new QBoxLayout(parentLayout, d);
      }
    }
    else
    /* one row or column */
    {
      if (rule->isHorizontal())
        if (rule->isReverse())
          childLayout=new QBoxLayout(QBoxLayout::RightToLeft);
        else
          childLayout=new QBoxLayout(QBoxLayout::LeftToRight);
      else
        if (rule->isReverse())
          childLayout=new QBoxLayout(QBoxLayout::BottomToTop);
        else
          childLayout=new QBoxLayout(QBoxLayout::TopToBottom);

      parentLayout->addLayout(childLayout);
      parentLayout=childLayout;
    }

    int hasEpsilonChild=rule->whichEpsilonChild();
    QValueList<int> children=rule->children();

    int n=1;
    int def=rule->getDefault();
    QValueList<int>::Iterator ch;
    if (rule->isReverse()) def=children.count()+1-def;
    for (ch=children.begin(); ch!=children.end(); ++ch, n++)
    {
      ///////////////////////////////
      // Create tabs for all children
      if (rule->isTabbed())
      {
        QWidget * newWidget;
        QBoxLayout * newLayout;
        /* Each child on a separate tab */
        KRule * child=gr->getRule(*ch);
        if (child && !(child->getPlace()))
        {
          newWidget=new QWidget();
          tabWidget->insertTab(newWidget, child->getTitle(), rule->isReverse()?0:-1);
          if (rule->isReverse()) tabWidget->setCurrentPage(tabWidget->currentPageIndex()+1);
          newLayout=new QVBoxLayout(newWidget, BORDER, SPACING);
          KPlace * childPlace=new KPlace(child, false, subFramed, subNeedRadio,
                                        subNeedCheck, subNeedTristate,
                                        newWidget, newLayout, this, parentDialog);
          /* radio children's control */
          if (subNeedRadio)
          {
            /* default selected */
            if (n==def) childPlace->radio->setChecked(true);
            connect(childPlace, SIGNAL(clicked(KPlace *)), SLOT(selected(KPlace *)));
          }

          subPlaces.append(childPlace);
        }
      } else
      ///////////////////////////////
      // children on one by one
      {
        KRule * child=gr->getRule(*ch);
        /* in case of check box, discard epsilon child */
        if (child
           && !(n==hasEpsilonChild && subNeedCheck)
           && !(n!=1 && subNeedTristate)
           && !(child->getPlace()))
        {
          if (rule->isDouble() && subNeedRadio)
            parentLayout=parentLayouts[(n-1)%2];

          KPlace * childPlace=new KPlace(child, true, subFramed, subNeedRadio,
                                         subNeedCheck, subNeedTristate,
                                         parentWidget, parentLayout, this, parentDialog);
          /* radio children's control */
          if (subNeedRadio)
          {
            /* default selected */
            if (n==def) childPlace->radio->setChecked(true);
            connect(childPlace, SIGNAL(clicked(KPlace *)), SLOT(selected(KPlace *)));
          }
          /* set the checkbox if needed */
          if (subNeedCheck)
          {
            if (hasEpsilonChild!=def)
              childPlace->check->setChecked(true);
          }
          /* set the checkbox for tristates */
          if (subNeedTristate)
            switch (def)
            {
              case 1:
                childPlace->check->setChecked(QButton::On);
                break;
              case 2:
                childPlace->check->setNoChange();
                break;
              case 3:
                childPlace->check->setChecked(QButton::Off);
                break;
              default:
                break;
            }

          subPlaces.append(childPlace);
        }
      }
    } // for
  } // if (isDisjunctive || isConjunctive)

//  parentLayout->addStretch(-1);
}
	
KPlace::KPlace(KRule * rp, QWidgetStack * myStack, QListView * parentListView,
               QListViewItem * parentItem, KRule * parentRule, QListViewItem * before,
               QPtrDict<KPlace> * dict)
{
  if (!rp) return;
  bool iAlreadyExist=(rp->getPlace())!=0;
  clearAttributes();

  rule=rp;
  rule->setPlace(this);

  bool disj, checkItem;
  QCheckListItem::Type type;
  QString label, pic, tooltip;
  KRule * noEpsRule=0;

  /* figure out what kind of item it should be */
  if (rule->isCheckBox()) {
    checkItem=true;disj=true;
    type=QCheckListItem::CheckBox;
    noEpsRule=gr->getRule(rule->rightSide()[2-rule->whichEpsilonChild()]);
    if (!noEpsRule) noEpsRule=rule;
    label=noEpsRule->getTitle();
    tooltip=noEpsRule->getToolTip();
  } else
  if (parentRule && parentRule->isDisjunctive()) {
    checkItem=true;disj=true;
    type=QCheckListItem::RadioButton;
    label=rule->getTitle();
    tooltip=rule->getToolTip();
  } else
  if (rule->isDisjunctive()) {
    checkItem=true;disj=false;
    type=QCheckListItem::Controller;
    label=rule->getTitle();
    tooltip=rule->getToolTip();
  } else
  {
//    item=new QListViewItem(parentItem, rule->getTitle());
    checkItem=false;disj=false;
    label=rule->getTitle();
    tooltip=rule->getToolTip();
  }

  /* check pixmap in the label */
  QRegExp r("^\\{[^\\}]*\\}");
  int len;
  int res=r.match(label, 0, &len);
  if (res!=-1)
  {
    pic=label.left(len-1);
    pic.remove(0,1);
    label.remove(0,len);
  }

  /* insert item into the tree */
  if (parentItem)
    if (checkItem)
      item=new QCheckListItem((QCheckListItem *)parentItem, label, type);
    else
      item=new QListViewItem(parentItem, label);
  else
    if (checkItem)
      item=new QCheckListItem(parentListView, label, type);
    else
      item=new QListViewItem(parentListView, label);

  if (type==QCheckListItem::CheckBox)
    ((QCheckListItem *)item)->setOn(rule->whichEpsilonChild()!=rule->getDefault());

  /* set pixelmap */
  if (!(pic.isEmpty()))
    item->setPixmap(0,loadPixmap(pic,3));

  item->moveItem(before);
  item->setText(1,tooltip); // detailed information
  dict->insert(item,this);

  /* is there a new page in the stack? */
  hasFriendPlace=!(rule->isTree() && !disj && (rule->isConjunctive() || rule->isDisjunctive()));

  if (hasFriendPlace)
  {
    QWidget * myWidget=new QWidget(myStack);
    QBoxLayout * myLayout=new QBoxLayout(myWidget,QBoxLayout::Down);
    if (rule->isCheckBox() && noEpsRule) rule=noEpsRule;
    friendPlace=new KPlace(rule,false,false,false,false,false,myWidget,myLayout,this,0,false,true);
    friendPlace->item=item;
    if (myStack) myStack->addWidget(myWidget,0);
    if ((rule->isSpecial() || rule->children().count()>0)
        && !iAlreadyExist) NUM_STACK_MEMBERS++;
    pW=myWidget;
  } else
  {
    /* insert children into the tree */
    QValueList<int> children=rule->children();
    QValueList<int>::Iterator ch;
    /* for children */
    QListViewItem * lastItem=0;
    int n=1;
    int def=rule->getDefault();
    for (ch=children.begin(); ch!=children.end(); ++ch, ++n)
    {
      KRule * child=gr->getRule(*ch);
      KPlace * childPlace=new KPlace(child, myStack, parentListView, item, rule, lastItem, dict);
      if (n==def && rule->isDisjunctive()) ((QCheckListItem *)(childPlace->item))->setOn(true);
      lastItem=childPlace->item;
      subPlaces.append(childPlace);
    }
  }
}


KPlace::~KPlace()
{
}

void KPlace::clearAttributes()
{
  radio=0;
  check=0;
  spinBox=0;
  lineEdit=0;
  edit=0;
  pushButton=0;
  box=0;
  stack=0;
  listView=0;
  item=0;
  hasFriendPlace=false;
  friendPlace=0;
  myDict=0;
  isMultiCol=false;

  buttonchild=0;
  subdialog=0;
  source=0;
  pW=0;
}

void KPlace::pageSelected(QListViewItem * it)
{
  if (myDict)
  {
    KPlace * that=myDict->find(it);
    if (that && that->hasFriendPlace && stack)
      stack->raiseWidget(that->pW);
  }
}


QString KPlace::copy()
{
  return QString();
}

QString KPlace::cut()
{
  return QString();
}

void KPlace::paste(QString)
{
}

void KPlace::replace(QString)
{
}

void KPlace::selected()
{
  emit clicked(this);
}

bool KPlace::isSelected()
{
  if (radio) return radio->isChecked();
  if (check) return check->isChecked();
  if (item) return ((QCheckListItem *)item)->isOn();
  return false;
}

int KPlace::getState()
{
  int n=1;
  switch (check->state())
  {
    case QButton::Off:
      n=3; break;
    case QButton::NoChange:
      n=2; break;
    case QButton::On:
      n=1; break;
    default:
      ;
  }
  return n;
}

/* slot called when button pressed */
void KPlace::invokeChild()
{
  if (!subdialog)
    if (rule->isWizard())
      subdialog=new KaptainWizard(rule, pW);
    else
      subdialog=new Kaptain(buttonchild, pW);
  subdialog->exec();
  subdialog->hide();
}

void KPlace::selected(KPlace * that)
{
  for (KPlace * p=subPlaces.first(); p; p=subPlaces.next())
    if (that!=p && p->radio) p->radio->setChecked(false);
  if (that && that->radio && !(that->radio->isChecked())) that->radio->setChecked(true);
}
	
QString KPlace::evaluate()
{
  QString result;
  /* just for special rules! */
  if (rule->isSpecial())
  switch (rule->getSpecType())
  {
    case 0: /* @integer */
      result=spinBox->text();
      break;
    case 1: /* @string */
    case 3: /* @float */
    case 5: /* @regexp */
    case 6: /* @infile */
    case 7: /* @outfile */
    case 8: /* @directory */
    case 24: /* @password */
      result=lineEdit->text();
      break;
    case 4: /* @button */
      if (buttonchild) result=buttonchild->evaluate();
      break;
    case 2: /* @list */
    case 9: /* @combo */
    case 14:/* @combow */
    {
      int i;
      if (rule->getSpecType()==2)
        if (!(myList.isEmpty()) )
          if ((i=((QListBox *)box)->currentItem())!=-1) result+=myList[i]; else ;
        else
          result+=((QListBox *)box)->currentText();
      else
        if (rule->getSpecType()==9 && !(myList.isEmpty()) )
          if ((i=((QComboBox *)box)->currentItem())!=-1) result+=myList[i]; else ;
        else
          result+=((QComboBox *)box)->currentText();
      break;
    }
    case 10: /* @container */
    {
      QListBox * list=(QListBox *)box;
      for (uint i=0; i<list->count(); i++)
        result+=list->text(i);
      break;
    }
    case 13: /* @edit */
      result=edit->text();
      break;
    case 20: /* @execbuffer */
      result=buffer;
      break;
    case 11: /* @close */
    case 12: /* @action */
    case 15: /* @exec */
    case 16: /* @echo */
    case 17: /* @icon */
    case 18: /* @text */
    case 19: /* @execclose */
    case 21: /* @dump */
    case 22: /* @preview */
    case 23: /* @size */
    case 25: /* @fork */
    case 26: /* @fill */
    case 27: /* @multicol */
    {
      QListViewItem * p=0;
      if (listView && (p=listView->currentItem()))
      result=p->text(listView->columns());
      break;
    }
    default:
      break;
  }

  return result;
}

void KPlace::contentChanged()
{
}

void KPlace::addClicked()
{
  if (box && source)
  {
    QString eval=source->evaluate(false);
    if (!(eval.isEmpty()))
    {
      ((QListBox *)box)->insertItem(eval);
      /* Should it be removed from source? */
    }
  }
}

void KPlace::getFile()
{
  if (lineEdit)
  {
    QString filter;
    if (rule->getParams())
    {
      param_type * p=rule->getParams()->first();
      if (p && (p->type==0))
        filter = *(p->strData);
    }
    QString newFile;
    if (rule->isSpecial() && rule->getSpecType()==6)
      newFile=KFileDialog::getOpenFileName(QString::null, filter);
    if (rule->isSpecial() && rule->getSpecType()==7)
      newFile=KFileDialog::getSaveFileName(QString::null, filter);
    if (rule->isSpecial() && rule->getSpecType()==8)
      newFile=KFileDialog::getExistingDirectory();
    if (!(newFile.isEmpty())) lineEdit->setText(newFile);
  }
}

/* creates a preview dialog for the evaluatoin of the given nonterminal */
void KPlace::preview()
{
  QString sentence;
  param_type * p;
  QList<param_type> * params=rule->getParams();
  QDialog * view=new QDialog(myDialog,0,true);
  QBoxLayout * lay=new QVBoxLayout(view);
  QTextView * label=new QTextView(view);
  QPushButton * button=new QPushButton(view);
  lay->addWidget(label);
  lay->addWidget(button);
  connect(button, SIGNAL(clicked()),view, SLOT(accept()));

  p=params->first();
  if (p && p->type==2 && gr->getRule(p->intData))
      sentence=gr->getRule(p->intData)->evaluate();
  p=params->next();
  if (p && p->type==0) button->setText(*(p->strData));
    else  button->setText("OK");
  button->setFixedSize(button->sizeHint());
  label->setText(sentence);
  view->exec();
  delete lay;
  delete view;
}

void KPlace::action()
{
  QString command;
  param_type * p;
  QList<param_type> * params=rule->getParams();

  /* concatenate the command */
  for (p=params->first(); p; p=params->next())
  {
    if (p->type==2 && gr->getRule(p->intData))
      command+=gr->getRule(p->intData)->evaluate();
    else
      if (p->type==0)
        command+=(*p->strData);
  }
  /* print command if test flag is set or @echo or @dump*/
  if (test_flag || rule->getSpecType()==16 || rule->getSpecType()==21)
    cout << command << endl;
  else /* @execbuffer */
  if (rule->getSpecType()==20)
  {
    if (pushButton) pushButton->setEnabled(false);
    QStringList commandList;
    KExecutor * exec=new KExecutor();
    if (params->count()==1)
      buffer=exec->execute(command);
    else
    {
      /* each parameter is a separate argument */
      for (p=params->first(); p; p=params->next())
      {
        if (p->type==2 && gr->getRule(p->intData))
          commandList.append(gr->getRule(p->intData)->evaluate());
        else
          if (p->type==0)
            commandList.append(*p->strData);
      }
      buffer=exec->execute(command);
    }
    if (pushButton) pushButton->setEnabled(true);
  }
  else /* @exec @action @execclose @fork */
  /* execute command */
  {
    if (pushButton && rule->getSpecType()!=25) pushButton->setEnabled(false);
    KProcess * bash;
    if (params->count()==1)
    {
      bash=new KShellProcess();
      *bash << command;
    }
    else
    {
      bash=new KProcess();
      /* each parameter is a separate argument */
      for (p=params->first(); p; p=params->next())
      {
        if (p->type==2 && gr->getRule(p->intData))
          *bash << gr->getRule(p->intData)->evaluate();
        else
          if (p->type==0)
            *bash << (*p->strData);
      }
    }
    connect(bash, SIGNAL(processExited(KProcess *)), SLOT(processExited(KProcess *)));
    bash->start();
  }
  if (rule->getSpecType()==15 || /* @exec */
      rule->getSpecType()==21)   /* @dump */
     qApp->quit();
}

void KPlace::processExited(KProcess * proc)
{
  if (pushButton && rule->getSpecType()!=25) pushButton->setEnabled(true);
  delete proc;
}

void KPlace::removeClicked()
{
  if (box)
    ((QListBox *)box)->removeItem(((QListBox *)box)->currentItem());
}

QWidget * KPlace::makeSpecial (KRule * rule, QWidget * parentWidget, QBoxLayout * parentLayout)
{
  param_type * p;
  QList<param_type> * params=rule->getParams();
  switch (rule->getSpecType())
  {
    case 0: /* @integer */
    {
      spinBox=new QSpinBox(parentWidget);
      spinBox->setFixedSize(spinBox->sizeHint());
      /* min and max value */
      if (params)
      {
        p=params->first();if (p && p->type==1) spinBox->setMinValue(p->intData);
        p=params->next(); if (p && p->type==1) spinBox->setMaxValue(p->intData);
      }
      /* set initial value */
      p=rule->getInitValue();
      if (p && p->type==1) spinBox->setValue(p->intData);

      return spinBox;
    }
    case 1: /* @string */
    case 24: /* @password */
    {
      lineEdit=new QLineEdit(parentWidget);
      if (rule->getSpecType()==24) lineEdit->setEchoMode(QLineEdit::Password);
      /* set initial value */
      p=rule->getInitValue();
      if (p && p->type==0) lineEdit->setText(*(p->strData));
      /* set maximum length */
      if (params)
      {
        p=params->first();if (p && p->type==1) lineEdit->setMaxLength(p->intData);
      }

      return lineEdit;
    }
    case 2:  /* @list */
    case 9:  /* @combo */
    case 14: /* @combow */
    {
      if (rule->getSpecType()==2)
        box=new QListBox(parentWidget);
      else
        box=new QComboBox(rule->getSpecType()==14, parentWidget);

      /* split parameters the way every line is a different element in the listbox */
      QStringList lines;
      if (params)
      {
        param_type * mySubst=0;
        p=params->first();
        if (p && p->type==4) /* substitution */
        {
          mySubst=p;
          p=params->next();
        }

        for (p=params->first(); p; p=params->next())
          if (p->type==0)
            lines+=QStringList::split(QChar('\n'),*(p->strData));
        /* only for @list, @combo, not for writeable combo */
        /* allow for substituted lines to appear on the screen */
        if (rule->getSpecType()!=14 && mySubst)
        {
          myList=lines;
          QString from,to;
          for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it )
          {
            from=(*it);
            bool global=mySubst->strsData[2]!=NULL;
            substitute(*(mySubst->strsData[0]),from,*(mySubst->strsData[1]),to,global);
            (*it)=to;
          }
        }
        if (rule->getSpecType()==2)
          ((QListBox *)box)->insertStringList(lines);
        else
          ((QComboBox *)box)->insertStringList(lines);
      }

      p=rule->getInitValue();
      if (p && !isMultiCol)
      {
        /* set initial index value */
        if (p->type==1) {
          if (rule->getSpecType()==2)
            ((QListBox *)box)->setCurrentItem(p->intData-1);
          else
            ((QComboBox *)box)->setCurrentItem(p->intData-1);
         }

        /* set initial string value */
        if (p->type==0) {
          if (rule->getSpecType()==2) {
            for (int i = 0;i < ((QListBox *)box)->count();i++) {
              if ( qstrcmp(((QListBox *)box)->text(i),*(p->strData)) == 0 )
                ((QListBox *)box)->setCurrentItem(i);
              }
        } else {
           for (int i = 0;i < ((QComboBox *)box)->count();i++) {
               if ( qstrcmp(((QComboBox *)box)->text(i),*(p->strData)) == 0 )
                       ((QComboBox *)box)->setCurrentItem(i);
           }
          }
        }
      }

      return (QWidget *)box;
    }
    case 3: /* @float */
    {
      lineEdit=new QLineEdit(parentWidget);
      lineEdit->setValidator(new QDoubleValidator(parentWidget));
      /* set initial value */
      p=rule->getInitValue();
      if (p && (p->type==0)) lineEdit->setText(*(p->strData));
      return lineEdit;
    }
    case 4:  /* @button */
    case 11: /* @close */
    case 12: /* @action */
    case 15: /* @exec */
    case 16: /* @echo */
    case 19: /* @execclose */
    case 20: /* @execbuffer */
    case 21: /* @dump */
    case 22: /* @preview */
    case 25: /* @fork */
    {
      pushButton=new QPushButton(parentWidget);
      /* set button text */
      p=rule->getInitValue();
      if (p && p->type==0) pushButton->setText(*(p->strData));
      /* parameters */
      if (params)
      {
        /* @button */
        if (rule->getSpecType()==4) {
          p=params->first();
          if (p && p->type==2) {
            buttonchild=gr->getRule(p->intData);
            pW=parentWidget;
            connect(pushButton, SIGNAL(clicked()), SLOT(invokeChild()));
          }
        }
      }
      /* @action, @exec, @echo @execbuffer @execclose @dump @fork*/
      if (rule->getSpecType()==12
        || rule->getSpecType()==15
        || rule->getSpecType()==16
        || rule->getSpecType()==19
        || rule->getSpecType()==20
        || rule->getSpecType()==21
        || rule->getSpecType()==25)
        connect(pushButton, SIGNAL(clicked()), SLOT(action()));

      /* @close or @execclose */
      if ((rule->getSpecType()==11 || rule->getSpecType()==19) && myDialog)
        connect(pushButton, SIGNAL(clicked()), myDialog, SLOT(accept()));
      /* @preview */
      if (rule->getSpecType()==22)
        connect(pushButton, SIGNAL(clicked()), SLOT(preview()));
      pushButton->setFixedSize(pushButton->sizeHint());
      return pushButton;
    }
    case 5: /* @regexp */
    {
      lineEdit=new QLineEdit(parentWidget);
      /* set validator befor the string */
      if (params)
      {
        p=params->first();
        if (p && ((p->type==0) || (p->type==3)))
          lineEdit->setValidator(new QRegValidator(*(p->strData), parentWidget));
      }
      /* set regular expression */
      p=rule->getInitValue();
      if (p && (p->type==0)) lineEdit->setText(*(p->strData));
      return lineEdit;
    }
    case 6:  /* @infile */
    case 7:  /* @outfile */
    case 8:  /* @directory */
    {
      QHBox * holder=new QHBox(parentWidget);
      ((QHBox *)holder)->setSpacing(SPACING);
      lineEdit=new QLineEdit(holder);
      pushButton=new QPushButton("...",holder);
      pushButton->setFixedSize(pushButton->sizeHint());
      connect(pushButton, SIGNAL(clicked()), SLOT(getFile()));
      /* set initial value */
      p=rule->getInitValue();
      if (p && (p->type==0)) lineEdit->setText(*(p->strData));
      return holder;
    }
    case 10: /* @container */
    {
      QWidget * holder=new QVBox(parentWidget);
      ((QVBox *)holder)->setSpacing(SPACING);
      QWidget * buttons=new QHBox(holder);
      ((QHBox *)buttons)->setSpacing(SPACING);
      QPushButton * add=new QPushButton(buttons);
      QPushButton * remove=new QPushButton(buttons);
      add->setText("Add");
      add->setFixedSize(add->sizeHint());
      remove->setText("Remove");
      remove->setFixedSize(remove->sizeHint());

      /* set source */
      if (params)
      {
        p=params->first();
        if (p && (p->type==2)) source=gr->getRule(p->intData);
        else source=0;
      }

      box=new QListBox(holder);
      connect(add, SIGNAL(clicked()), SLOT(addClicked()));
      connect(remove, SIGNAL(clicked()), SLOT(removeClicked()));
      return holder;
    }
    case 13: /* @edit */
    {
      edit=new QMultiLineEdit(parentWidget);
      /* set font */
      if (params)
      {
        p=params->first();
        if (p && p->type==0)
        {
          edit->setFont(QFont(*(p->strData)));
          p=params->next();
        }
        if (p && p->type==1)
        {
          edit->setMinimumWidth(p->intData);
          p=params->next();
        }
        if (p && p->type==1)
        {
          edit->setMinimumHeight(p->intData);
          p=params->next();
        }
      }
      /* set initial value */
      p=rule->getInitValue();
      if (p && p->type==0) edit->setText(*(p->strData));
      return edit;
    }
    case 17: /* @icon */
    {
      QLabel * place=new QLabel(parentWidget);
      QPixmap * icon=new QPixmap;
      if (params)
      {
        p=params->first();
        if (p && (p->type==0))
          *icon=loadPixmap(*(p->strData), 0);
      }
      place->setPixmap(*icon);
      place->setFixedSize(icon->size());
      return place;
    }
    case 18: /* @text */
    {
      QLabel * text=new QLabel(parentWidget);
      text->setAlignment(AlignLeft|AlignTop|WordBreak);
      text->setFrameStyle(QFrame::Panel | QFrame::Sunken);
      p=rule->getInitValue();
      /* concatenate parameters */
      QStringList lines;
      if (params)
      {
        for (p=params->first(); p; p=params->next())
          if (p->type==0)
            lines+=(*(p->strData));
      }
      text->setText(lines.join(QString()));
      return text;
    }
    case 23: /* @size */
    {
      //parentLayout->setFixedSize();
    }
    case 26: /* @fill */
    {
      QWidget * fill=new QWidget(parentWidget);
      parentLayout->addWidget(fill,1);
      return fill;
    }
    case 27: /* @multicol */
    {
      /* split parameters the way every line is a different element in the listbox */
      QStringList lines;
      if (params)
      {
        param_type * mySubst=0;
        QString pattern;
        p=params->first();
        if (p && p->type==4) /* substitution */
        {
          mySubst=p;
          p=params->next();
        }
        if (p && p->type==3) /* regexp pattern for matching */
        {
          pattern=*p->strData;
          isMultiCol=true;
        }

        for (p=params->first(); p; p=params->next())
          if (p->type==0)
            lines+=QStringList::split(QChar('\n'),*(p->strData));
        myList=lines;
        /* substitution */
        if (mySubst)
        {
          QString from,to;
          for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it )
          {
            from=(*it);
            bool global=mySubst->strsData[2]!=NULL;
            substitute(*(mySubst->strsData[0]),from,*(mySubst->strsData[1]),to,global);
            (*it)=to;
          }
        }
        int defNum=1;
        p=rule->getInitValue();
        if (p && p->type==1)
          /* set initial index value */
          defNum= p->intData;

        QList<QStringList> itemList;
        itemList.setAutoDelete(true);
        QStringList * oneLine;
        int n, j=0, columnNum=0;
        /* split the lines according to pattern */
        for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it )
        {
          oneLine=new QStringList();
          n=match(pattern, *it, *oneLine);
          if (n) oneLine->append(myList[j]);
          if (n>columnNum) columnNum=n;
          itemList.append(oneLine);
          j++;
        }
        /* determine the header and the allocate the columns */
        listView=new QListView(parentWidget);
        listView->setAllColumnsShowFocus(true);
        oneLine=itemList.first();
        for (n=0; n<columnNum; n++)
          if (n<oneLine->count())
            listView->addColumn((*oneLine)[n]);
          else
            listView->addColumn("");
        /* insert lines into the box */
        QListViewItem * item, *defItem=0;
        j=0;
        for (oneLine=itemList.next(); oneLine; oneLine=itemList.next())
          if (oneLine->count())
          {
            item=new QListViewItem(listView);
            /* select first item */
            if (defItem==0 || j==defNum-1)
              defItem=item;
            for (int i=0; i<oneLine->count(); i++)
              item->setText(i, (*oneLine)[i]);
            j++;
          }
        if (defItem)
          listView->setSelected(defItem,true);
      } /* if params */



/*      p=rule->getInitValue();
      if (p)
      {
        /* set initial index value *
        if (p->type==1) {
          listView->setCurrentItem(p->intData-1);

        /* set initial string value *
        if (p->type==0) {
          if (rule->getSpecType()==2) {
            for (int i = 0;i < ((QListBox *)box)->count();i++) {
              if ( qstrcmp(((QListBox *)box)->text(i),*(p->strData)) == 0 )
                ((QListBox *)box)->setCurrentItem(i);
              }
        } else {
           for (int i = 0;i < ((QComboBox *)box)->count();i++) {
               if ( qstrcmp(((QComboBox *)box)->text(i),*(p->strData)) == 0 )
                       ((QComboBox *)box)->setCurrentItem(i);
           }
          }
        }
      }*/

      return (QWidget *)listView;
    }
    default:
      ;
  }
  QString * unknown=new QString("Unknown");
  return new QLabel(*unknown, parentWidget);
}
