/*
    snessystem.cpp - Super Nintendo Entertainment System Kamefu system plugin

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "snessystem.h"

// KDE Includes
#include <kgenericfactory.h>
#include <kdebug.h>

// Kamefu includes
#include "rommetadatafactory.h"

#include "snesrommetadata.h"

typedef KGenericFactory<SnesSystem> SnesSystemFactory;
K_EXPORT_COMPONENT_FACTORY( kamefu_snes, SnesSystemFactory( "kamefu_snes" )  )

class SnesSystem::Private
{
};

SnesSystem::SnesSystem(QObject *parent, const char *name, const QStringList& /*args*/)
 : Kamefu::System(parent, name)
{
	
	if ( s_snesSystem )
		kdDebug()<< k_funcinfo << "SNES system already initialized" << endl;
	else
		s_snesSystem = this;

	d = new Private;

	registerSystemMimeType( QString::fromUtf8("application/x-rom-snes") );
	Kamefu::RomMetaDataFactory::self()->addRomMetaDataFactory( QString::fromUtf8("application/x-rom-snes"), new SnesRomMetaData);
}


SnesSystem::~SnesSystem()
{
	delete d;
	s_snesSystem = 0L;	
}

SnesSystem *SnesSystem::system()
{
	return s_snesSystem;
}

SnesSystem *SnesSystem::s_snesSystem = 0L;

#include "snessystem.moc"
