/*
    nessystem.cpp - Nintendo Entertainment System Kamefu system plugin

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "nessystem.h"

// KDE Includes
#include <kgenericfactory.h>
#include <kdebug.h>

// Kamefu includes
#include <rommetadatafactory.h>

#include "nesrommetadata.h"

typedef KGenericFactory<NesSystem> NesSystemFactory;
K_EXPORT_COMPONENT_FACTORY( kamefu_nes, NesSystemFactory( "kamefu_nes" )  )

class NesSystem::Private
{
};

NesSystem::NesSystem(QObject *parent, const char *name, const QStringList& /*args*/)
 : Kamefu::System(parent, name)
{
	
	if ( s_nesSystem )
		kdDebug()<< k_funcinfo << "NES system already initialized" << endl;
	else
		s_nesSystem = this;

	d = new Private;

	registerSystemMimeType( QString::fromUtf8("application/x-rom-nes") );
	Kamefu::RomMetaDataFactory::self()->addRomMetaDataFactory( QString::fromUtf8("application/x-rom-nes"), new NesRomMetaData );
}


NesSystem::~NesSystem()
{
	delete d;
	s_nesSystem = 0L;	
}

NesSystem *NesSystem::system()
{
	return s_nesSystem;
}

NesSystem *NesSystem::s_nesSystem = 0L;

#include "nessystem.moc"
