/******************************************************************************
	metadataeditdialog.h - Dialog for viewing/editing ROM metadata info.
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	
	Copyright (c) 2006 by Michaël Larouche <michael.larouche@kdemail.net>

	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#ifndef METADATAEDITDIALOG_H
#define METADATAEDITDIALOG_H

#include <kdialogbase.h>
#include <kurl.h>

class QVBox;
/**
 * @internal
 * Set common KDialogBase information for MetadataEditDialog single and multiple mode
 */
class MetadataEditDialogPrivate : public KDialogBase
{
public:
	MetadataEditDialogPrivate(const QString &caption, QWidget *parent);
protected:
	QVBox *m_overviewPage;
};

/**
 * @brief Dialog for editing/viewing ROM metadata info.
 *
 * @author Brian S. Stephan <bssteph@incorporeal.org>
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class MetadataEditDialog : public MetadataEditDialogPrivate
{
	Q_OBJECT
public:
	/**
	 * Create a new MetadataEditDialog.
	 * @param parent this widget's parent
	 * @param caption caption of the widget
	 */
	MetadataEditDialog(const QString &romUrl, const QString &caption, QWidget *parent = 0);
	MetadataEditDialog(const KURL::List &romList, const QString &caption, QWidget *parent = 0);
	
	virtual ~MetadataEditDialog();

protected slots:
	/**
	 * Reimplented from KDialogBase.
	 * Called the User button 1 is clicked.
	 *
	 * Save the information in MetadataEdit and close the dialog.
	 */
	virtual void slotUser1();
	
private slots:
	/**
	 * Wrapper around enableButton(ButtonId, enabled).
	 * Enable/disable the save and close button.
	 */
	void slotEnabledSaveButton(bool enable);

	/**
	 * @internal
	 * Common initiation.
	 */
	void init();
signals:
	/**
	 * Metadata was changed. This comes from the widget, we just pass it along.
	 */
	void metadataChanged(const QString &romUrl);
	/**
	 * Group of metadata was changed. This come from the widget, we just pass it along.
	 */
	void metadataChanged(const KURL::List &romList);

private:
	class Private;
	Private *d;
};



#endif
