/*
    kamefuemulatorconfig.cpp - Emulator configuration

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "kamefuemulatorconfig.h"

// Qt includes
#include <qlayout.h>
#include <qlabel.h>
#include <qvaluelist.h>

// KDE includes
#include <kdebug.h>
#include <kgenericfactory.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kglobal.h>

// Kamefu includes
#include <systemmanager.h>
#include <system.h>

// Own includes
#include "emulatorconfigwidget.h"

class KamefuEmulatorConfig::Private
{
public:
	QValueList<EmulatorConfigWidget*> emulatorConfigList;
};

typedef KGenericFactory<KamefuEmulatorConfig, QWidget> KamefuEmulatorConfigFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kamefu_emulatorconfig, KamefuEmulatorConfigFactory( "kcm_kamefu_emulatorconfig" ) )

KamefuEmulatorConfig::KamefuEmulatorConfig(QWidget* parent, const char* /*name*/, const QStringList& args)
	: KCModule( KamefuEmulatorConfigFactory::instance(), parent, args ), d( new Private() )
{
// 	( new QVBoxLayout( this ) )->setAutoAdd( true );
	QVBoxLayout *mainLayout = new QVBoxLayout(this);

	// Iterator over all loaded system and create a EmulatorConfigWidget
	Kamefu::SystemList systemList = Kamefu::SystemManager::self()->loadedSystems();
	Kamefu::SystemList::const_iterator systemIt;
	Kamefu::SystemList::const_iterator systemItEnd = systemList.end();
	for(systemIt = systemList.begin(); systemIt != systemItEnd; ++systemIt)
	{
		Kamefu::System *system = *systemIt;
		if(system)
		{
			EmulatorConfigWidget *emuConfig = new EmulatorConfigWidget(system->displayName(), this);
			// Dispatch settings changed.
			connect(emuConfig, SIGNAL(settingsChanged()), this, SLOT(settingsChanged()));
			d->emulatorConfigList.append(emuConfig);
			mainLayout->addWidget(emuConfig);
		}
	}

	// Add a spacer item
	mainLayout->addItem( new QSpacerItem( 20, 40, QSizePolicy::Expanding, QSizePolicy::Minimum ) );

	load();
}

KamefuEmulatorConfig::~KamefuEmulatorConfig()
{
	delete d;
}

void KamefuEmulatorConfig::load()
{
	QValueList<EmulatorConfigWidget*>::iterator configIt;
	QValueList<EmulatorConfigWidget*>::iterator configItEnd = d->emulatorConfigList.end();
	for(configIt = d->emulatorConfigList.begin(); configIt != configItEnd; ++configIt)
	{
		((EmulatorConfigWidget*)*configIt)->loadSettings();
	}
	KCModule::load();
}

void KamefuEmulatorConfig::save()
{
	QValueList<EmulatorConfigWidget*>::iterator configIt;
	QValueList<EmulatorConfigWidget*>::iterator configItEnd = d->emulatorConfigList.end();
	for(configIt = d->emulatorConfigList.begin(); configIt != configItEnd; ++configIt)
	{
		((EmulatorConfigWidget*)*configIt)->saveSettings();
	}
	KCModule::save();
}

void KamefuEmulatorConfig::settingsChanged()
{
	emit changed(true);
}

#include "kamefuemulatorconfig.moc"
