/*
    mamesystem.cpp - MAME Kamefu system plugin

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "mamesystem.h"

// KDE Includes
#include <kgenericfactory.h>
#include <kdebug.h>

// Kamefu includes
#include "rommetadatafactory.h"

#include "mamerommetadata.h"

typedef KGenericFactory<MameSystem> MameSystemFactory;
K_EXPORT_COMPONENT_FACTORY( kamefu_mame, MameSystemFactory( "kamefu_mame" )  )

class MameSystem::Private
{
};

MameSystem::MameSystem(QObject *parent, const char *name, const QStringList& /*args*/)
 : Kamefu::System(parent, name)
{
	
	if ( s_mameSystem )
		kdDebug()<< k_funcinfo << "MAME system already initialized" << endl;
	else
		s_mameSystem = this;

	d = new Private;

	registerSystemMimeType( QString::fromUtf8("application/x-mame") );
	Kamefu::RomMetaDataFactory::self()->addRomMetaDataFactory( QString::fromUtf8("application/x-mame"), new MameRomMetaData);
}


MameSystem::~MameSystem()
{
	delete d;
	s_mameSystem = 0L;	
}

MameSystem *MameSystem::system()
{
	return s_mameSystem;
}

MameSystem *MameSystem::s_mameSystem = 0L;

#include "mamesystem.moc"
