/*
    gbarommetadata.h - Extract metadata(information) from GBA ROM file.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef GBAROMMETADATA_H
#define GBAROMMETADATA_H

#include <defaultrommetadata.h>

/**
 * Extract metadata(information) from GBA ROM file.
 * 
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class GbaRomMetaData : public Kamefu::DefaultRomMetaData
{
public:
	GbaRomMetaData();
	~GbaRomMetaData();
	
	virtual Kamefu::RomMetaInformation extractMetaInformation(KFileItem* item);
	virtual Kamefu::RomMetaInformation extractMetaInformation(QIODevice* device);
};

#endif
