/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "imagethumbpage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qlabel.h>

ImageThumbPage::ImageThumbPage(QWidget *parent, const char *name)
    :KImageThumbPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));

  ImageUpBtn->setIconSet(BarIconSet("up"));
  ImageDownBtn->setIconSet(BarIconSet("down"));
  ImageTopBtn->setIconSet(BarIconSet("top"));
  ImageBottomBtn->setIconSet(BarIconSet("bottom"));

  ThumbUpBtn->setIconSet(BarIconSet("up"));
  ThumbDownBtn->setIconSet(BarIconSet("down"));
  ThumbTopBtn->setIconSet(BarIconSet("top"));
  ThumbBottomBtn->setIconSet(BarIconSet("bottom"));

  connect(ImageUpBtn,SIGNAL(pressed()),this,SLOT(slotModifyImageList()));
  connect(ImageDownBtn,SIGNAL(pressed()),this,SLOT(slotModifyImageList()));
  connect(ImageTopBtn,SIGNAL(pressed()),this,SLOT(slotModifyImageList()));
  connect(ImageBottomBtn,SIGNAL(pressed()),this,SLOT(slotModifyImageList()));
  connect(ImageListBox,SIGNAL(highlighted(int)),this,SLOT(slotSelectInBothList(int)));

  connect(ThumbUpBtn,SIGNAL(pressed()),this,SLOT(slotModifyThumbList()));
  connect(ThumbDownBtn,SIGNAL(pressed()),this,SLOT(slotModifyThumbList()));
  connect(ThumbTopBtn,SIGNAL(pressed()),this,SLOT(slotModifyThumbList()));
  connect(ThumbBottomBtn,SIGNAL(pressed()),this,SLOT(slotModifyThumbList()));
  connect(ThumbListBox,SIGNAL(highlighted(int)),this,SLOT(slotSelectInBothList(int)));
}

void ImageThumbPage::slotModifyImageList()
{
  if (ImageTopBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,0,-1);
    ImageTopBtn->setDown(false);
  }
  if (ImageUpBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,-1,0);
    ImageUpBtn->setDown(false);
  }
  if (ImageDownBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,1,0);
    ImageDownBtn->setDown(false);
  }
  if (ImageBottomBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,0,1);
    ImageBottomBtn->setDown(false);
  }
}

void ImageThumbPage::slotModifyThumbList()
{
  if (ThumbTopBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ThumbListBox,KalleryGlobals::ref()->options.thumbList,0,0,-1);
    ThumbTopBtn->setDown(false);
  }
  if (ThumbUpBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ThumbListBox,KalleryGlobals::ref()->options.thumbList,0,-1,0);
    ThumbUpBtn->setDown(false);
  }
  if (ThumbDownBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ThumbListBox,KalleryGlobals::ref()->options.thumbList,0,1,0);
    ThumbDownBtn->setDown(false);
  }
  if (ThumbBottomBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ThumbListBox,KalleryGlobals::ref()->options.thumbList,0,0,1);
    ThumbBottomBtn->setDown(false);
  }
}

void ImageThumbPage::slotSelectInBothList(int index)
{
  ImageListBox->setCurrentItem(index);
  ThumbListBox->setCurrentItem(index);
}

void ImageThumbPage::invokeHelp()
{
  kapp->invokeHelp("imagethumbnail-page","kallery");
}

bool ImageThumbPage::processPage()
{
  return true;
}

void ImageThumbPage::setupPage()
{
  QFileInfo fileInfo;

  ImageListBox->clear();
  ThumbListBox->clear();

  for (uint i =0; i<KalleryGlobals::ref()->options.imageList.count();i++)
  {
    fileInfo.setFile(KalleryGlobals::ref()->options.imageList[i]) ;
    ImageListBox->insertItem(fileInfo.fileName(),-1);
    fileInfo.setFile(KalleryGlobals::ref()->options.thumbList[i]) ;
    ThumbListBox->insertItem(fileInfo.fileName(),-1);
  }
}


#include "imagethumbpage.moc"
