/*
 * ts2rtp.h
 *
 * Copyright (C) 2003-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef TS2RTP_H
#define TS2RTP_H

#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "sender.h"



struct rtpbits {
  unsigned int v:2;           /* version: 2 */
  unsigned int p:1;           /* is there padding appended: 0 */
  unsigned int x:1;           /* number of extension headers: 0 */
  unsigned int cc:4;          /* number of CSRC identifiers: 0 */
  unsigned int m:1;           /* marker: 0 */
  unsigned int pt:7;          /* payload type: 33 for MPEG2 TS - RFC 1890 */
  unsigned int sequence:16;   /* sequence number: random */
};

struct rtpheader {	/* in network byte order */
  struct rtpbits b;
  int timestamp;	/* start: random */
  int ssrc;		/* random */
};



class Ts2Rtp : public Sender
{

public:

	Ts2Rtp();
	~Ts2Rtp();
	void setSocket( const QString &addr, int m_port, int m_senderPort );
	bool addChannel(const  QString &name, unsigned int pidv, unsigned int pida, char ac3, unsigned int spid, unsigned int pg, unsigned int an, unsigned int tp, const QString &lg );
	void removeChannel( const QString &name );
	void process( unsigned char *buf, int size );

private:

	bool makeSocket();
	void sendrtp( char *data, int len );

	int rtpSocket;
	struct sockaddr_in rtpAddr;
	struct rtpheader hRtp;
	QString address;
	int port, senderPort;
	unsigned char thBuf[188*10];
	int thWrite;
};

#endif /* TS2RTP_H */
