#ifndef DEBUG_H
#define DEBUG_H

#include "kadu-config.h"

/* pierwsze 8 bitow zarezerwowane jest dla libgadu */

/* start funkcji */
#define KDEBUG_FUNCTION_START (1<<8)
/* koniec funkcji */
#define KDEBUG_FUNCTION_END   (1<<9)

/* zwykle inforamcje */
#define KDEBUG_INFO           (1<<10)
/* niegrozne ostrzezenie */
#define KDEBUG_WARNING        (1<<11)
/* powazny blad, ale sytuacja jest do obejscia */
#define KDEBUG_ERROR          (1<<12)
/* blad fatalny, mozliwe ze program sie wywroci */
#define KDEBUG_PANIC          (1<<13)

/* duzo danych do wypisania */
#define KDEBUG_DUMP           (1<<14)
/* informacja dotyczaca obslugi sieci */
#define KDEBUG_NETWORK        (1<<15)

/* 2^31-1 - wszystkie komunikaty */
#define KDEBUG_ALL 2147483647

/*
	<<< kdebug >>>
	Wywietla komunikat debugujcy na konsoli.
	Skadnia jak w printf.
*/
#ifdef DEBUG_ENABLED
#define kdebug(format, args...) \
	_kdebug_with_mask(KDEBUG_ALL, __FILE__, __LINE__, format, ##args)
#define kdebugm(mask, format, args...) \
	_kdebug_with_mask(mask, __FILE__, __LINE__, format, ##args)
#define kdebugmf(mask, format, args...) \
	_kdebug_with_mask(mask, __FILE__, __LINE__, "%s: " format, __PRETTY_FUNCTION__, ##args)
#else
#define kdebug(format, args...)
#define kdebugm(mask, format, args...)
#define kdebugmf(mask, format, args...)
#endif


/*
	<<< kdebugf >>>
	Wywietla komunikat debugujcy zawierajcy
	nazw aktualnie wykonywanej funkcji.
	Z zaoenia makro to powinno by wywoane
	w pierwszej linii kadej funkcji. Dziki
	temu mona bdzie w przyszoci ledzi
	dziaanie programu.
*/	
#define kdebugf() \
	kdebugm(KDEBUG_FUNCTION_START, "%s\n", __PRETTY_FUNCTION__)

#define kdebugf2() \
	kdebugm(KDEBUG_FUNCTION_END, "%s end\n", __PRETTY_FUNCTION__)

/*
	Funkcja pomocnicza. Nie uywa.
*/
#ifdef DEBUG_ENABLED
void _kdebug_with_mask(int mask, const char *file, const int line, const char *format, ...) __attribute__((format (printf, 4, 5)));
#endif
extern int debug_mask;

#endif
