#ifndef ABOUT_H
#define ABOUT_H

#include <qstring.h>
#include <qhbox.h>
#include <qwidget.h>

class LayoutHelper;
class QResizeEvent;

/**
	\class About
	\brief Okno z informacjami o programie.
**/
class About : public QHBox {
	Q_OBJECT

	public:

		/**
			\fn About(QWidget *parent=NULL, const char *name=NULL)
			Konstruktor tworzy okno, ustawia zakadki z informacjami o autorach, podzikowaniach, licencji oraz list zmian w programie. \n
			Domylnie okno ma rozmiar 640x420.
			\param parent rodzic okna
			\param name nazwa obiektu
		**/
		About(QWidget *parent=NULL, const char *name=NULL);

		/**
			\fn ~About()
			Destruktor zapisuje rozmiar okna.
		**/
		~About();

	private:
		/**
			\fn QString loadFile(const QString &name)
			Funkcja zwracajca zawarto pliku.
			\param name nazwa pliku do przeczytania
		**/
		QString loadFile(const QString &name);

		/**
			\fn void keyPressEvent(QKeyEvent *)
			Funkcja obsugujca zdarzenie nacinicia przycisku
			Esc do zamknicia okna.
		**/
		void keyPressEvent(QKeyEvent *);

		LayoutHelper *layoutHelper;

	private slots:
		void refreshIcon(const QPixmap &);

	protected:
		virtual void resizeEvent(QResizeEvent *);
};

#endif
