# Compiler configuration
IF(WIN32)
	IF(MSVC)
		SET(K3D_COMPILER_MSVC TRUE)
	ELSE(MSVC)
		SET(K3D_COMPILER_GCC TRUE)
	ENDIF(MSVC)
ELSE(WIN32)
	SET(K3D_COMPILER_GCC TRUE)
ENDIF(WIN32)

# Win32 API configuration
IF(WIN32)
	SET(K3D_API_WIN32 TRUE)
ENDIF(WIN32)

# Darwin API configuration
IF(APPLE)
	SET(K3D_API_DARWIN TRUE)

  EXECUTE_PROCESS(
    COMMAND sw_vers -productVersion
    OUTPUT_VARIABLE K3D_OSX_VERSION
    )
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\1" K3D_OSX_MAJOR_VERSION "${K3D_OSX_VERSION}")
  STRING(REGEX REPLACE "([0-9]*)[.]([0-9]*)[.]([0-9]*).*" "\\2" K3D_OSX_MINOR_VERSION "${K3D_OSX_VERSION}")

ENDIF(APPLE)

