#ifndef JAVASCRIPT_OBJECT_H
#define JAVASCRIPT_OBJECT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Forward declarations
class JSContext;
class JSObject;
namespace k3d
{
	class iunknown;
}

/// Namespace reserved for the javascript plugin module, to protect public symbols from name clashes with other modules
namespace libk3djavascript
{

JSObject* create_application(k3d::iunknown& Object, JSContext* Context);
JSObject* create_document(k3d::iunknown& Object, JSContext* Context);
JSObject* create_document_object(k3d::iunknown& Object, JSContext* Context);
JSObject* create_generic_object(k3d::iunknown& Object, JSContext* Context);
JSObject* create_plugin_factory(k3d::iunknown& Object, JSContext* Context);
JSObject* create_property(k3d::iunknown& Object, JSContext* Context);
JSObject* create_user_interface(k3d::iunknown& Object, JSContext* Context);

} // namespace libk3djavascript

#endif // !JAVASCRIPT_OBJECT_H

