// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief An object that acts as a property source for scalar properties
		\author Bart Janssens (bart.janssens@polytechnic.be)
*/

#include <k3dsdk/object.h>
#include <k3dsdk/persistence.h>
#include <k3dsdk/measurement.h>
#include <k3dsdk/module.h>

namespace libk3dcore
{

class scalar_property_implemention : 
	public k3d::persistent<k3d::object> 
{
	typedef k3d::persistent<k3d::object> base;

public:
	scalar_property_implemention(k3d::idocument& Document) : 
		base(Document),
		m_value(k3d::init_name("value") + k3d::init_description("The value exposed by this property") + k3d::init_value(1.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.01) + k3d::init_units(typeid(k3d::measurement::scalar)))
	{
		enable_serialization(k3d::persistence::proxy(m_value));

		register_property(m_value);
	}
			
	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<k3d::document_plugin<scalar_property_implemention> > factory(
			k3d::uuid(0x35b28760,0x0547458f,0xb4e3d324,0x84ae3545),
			"ScalarProperty",
			"Provides a source object to link scalar properties to",
			"Objects",
			k3d::iplugin_factory::STABLE);
		return factory;
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}
	
private:
	// The scalar property itself:
	k3d_measurement_property(double, k3d::immutable_name, k3d::change_signal, k3d::with_undo, k3d::local_storage, k3d::no_constraint) m_value;
};

k3d::iplugin_factory& scalar_property_factory()
{
	return scalar_property_implemention::get_factory();
}

} //namespace libk3dcore
