# $Id: Morpheme.pm,v 1.1.1.1 2005/06/28 04:25:15 kuro Exp $
package Juman::Morpheme;
require 5.004_04; # For base pragma.
use Carp;
use strict;
use base qw/ Juman::Katuyou Juman::KULM::Morpheme /;
use vars qw/ @ATTRS /;

=head1 NAME

Juman::Morpheme - ǥ֥ in Juman

=head1 SYNOPSIS

  $m = new Juman::Morpheme( "   ̾ 6 ̾ 2 * 0 * 0" );

=head1 DESCRIPTION

ǤγƼݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( SPEC, ID )

1 I<SPEC>  Juman νϤƸƤӽФȡιԤƤ
Ϥǥ֥Ȥ롥

=back

=cut
@ATTRS = ( 'midasi',
	   'yomi',
	   'genkei',
	   'hinsi',
	   'hinsi_id',
	   'bunrui',
	   'bunrui_id',
	   'katuyou1',
	   'katuyou1_id',
	   'katuyou2',
	   'katuyou2_id',
	   'imis' );

sub new {
    my( $class, $spec, $id ) = @_;
    my $this = $id ? { id => $id } : {};

    my @value;
    my( @keys ) = @ATTRS;
    $spec =~ s/\s*$//;
    if( $spec =~ s/^\\  \\  \\  ü 1  6// ){
	@value = ( '\ ', '\ ', '\ ', 'ü', '1', '', '6' );
	push( @value, split( / /, $spec, scalar(@keys) - 7 ) );
    } else {
	@value = split( / /, $spec, scalar(@keys) );
    }
    while( @keys and @value ){
	my $key = shift @keys;
	$this->{$key} = shift @value;
    }

    bless $this, $class;
}

=head1 METHODS

=over 4

=item midasi

ǤθФ֤

=cut
sub midasi {
    shift->{midasi};
}

=item yomi

Ǥɤߤ֤

=cut
sub yomi {
    shift->{yomi};
}

=item genkei

Ǥθ֤

=cut
sub genkei {
    shift->{genkei};
}

=item hinsi

Ǥʻ֤

=cut
sub hinsi {
    shift->{hinsi};
}

=item hinsi_id

Ǥʻֹ֤

=cut
sub hinsi_id {
    shift->{hinsi_id} || undef;
}

=item bunrui

Ǥκʬ֤

=cut
sub bunrui {
    shift->{bunrui};
}

=item bunrui_id

Ǥκʬֹ֤

=cut
sub bunrui_id {
    shift->{bunrui_id};
}

=item katuyou1

Ǥγѷ֤

=cut
sub katuyou1 {
    shift->{katuyou1};
}

=item katuyou1_id

Ǥγѷֹ֤

=cut
sub katuyou1_id {
    shift->{katuyou1_id};
}

=item katuyou2

Ǥγѷ֤

=cut
sub katuyou2 {
    shift->{katuyou2};
}

=item katuyou2_id

Ǥγѷֹ֤

=cut
sub katuyou2_id {
    shift->{katuyou2_id};
}

=item imis

Ǥΰ̣֤̣ϡJuman  C<-e2> ץꤷ
Ƽ¹Ԥ롥

=cut
sub imis {
    shift->{imis};
}

=item push_doukei( DOUKEI )

Ʊ۵ I<DOUKEI> Ͽ롥

=cut
sub push_doukei {
    my( $this, $doukei ) = @_;
    $this->{doukei} ||= [];
    push( @{$this->{doukei}}, $doukei );
}

=item doukei

ǤƱ۵ΥꥹȤ֤

=cut
sub doukei {
    my( $this ) = @_;
    if( defined $this->{doukei} ){
	@{$this->{doukei}};
    } else {
	wantarray ? () : 0;
    }
}

=item id

󥹥ȥ饯ƤӽФȤ˻ꤷ ID ֤

=cut
sub id {
    my( $this ) = @_;
    $this->{id} || undef;
}

=item spec

ǥ֥ȤʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    sprintf( "%s\n", join( ' ', map( $this->{$_}, grep( defined $this->{$_}, @ATTRS ) ) ) );
}

1;

=back

=head1 SEE ALSO

=over 4

=item *

L<Juman::Katuyou>

=item *

L<Juman::KULM::Morpheme>

=back

=head1 AUTHOR

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
