
/*
 * juice.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JUICE_H
#define JUICE_H

/*
 * Help flags
 */

static bool main_has_help;
static bool setup_has_help;
static bool mixer_has_help;
static bool browse_has_help;
static bool rearrange_has_help;
static bool playlists_has_help;
static bool save_has_help;
static bool load_has_help;
static bool newtrack_has_help;
static bool curtrack_has_help;
static bool stopresume_has_help;
static bool help_has_help;
static bool path_has_help;
static bool input_has_help;
static bool mpg123_has_help;

/*
 * Configuration variables
 */

char *audiopath;
char *playlistpath;
char *playername;
char *audiotype;
char *playlisttype;
char *mpg123name;
bool confirmdialogs;
volatile bool mpg123frontend;
int fadingtime;
bool intersessionmemory;
bool helpdialogs;
int displaymode;
int displayformat;
int shortenmethod;

char currentplaylist[256];

/*
 * Dialogs
 */

Menus Lst;

/*
 * Forward declarations
 */

static void quit ();
static void previous ();
static void setup_main ();
static void setup_confirmdialogs ();
static void setup_mpg123frontend ();
static void setup_setaudiopath ();
static void setup_setplaylistpath ();
static void setup_setplayer ();
static void setup_mpg123name ();
static void setup_setaudiotype ();
static void setup_setplaylisttype ();
static void setup_setfadetime ();
static void setup_show ();
static void setup_save ();
static void setup_help ();
static void mixer_main ();
static void mixer_help ();
static void mixer_load ();
static void mixer_save ();
//static void playlists_create ();
static void playlists_save ();
static void playlists_load ();
static void edit_help ();
static void browse_help ();
static void rearrange_help ();
static void playlists_help ();
static void save_help ();
static void load_help ();
static void newtrack_help ();
static void curtrack_help ();
static void stopresume_help ();
static void help_help ();
static void audiopath_help ();
static void playlistpath_help ();
static void input_help ();
static void track_playcurrent ();
static void track_playupto ();
static void track_playfrom ();
static void track_playall ();
static void track_pause ();
static void track_resume ();
static void track_stop ();
static void track_skip ();
static void mpg123_help ();
static void setup_intersessionmemory ();
static void setup_helpdialogs ();
static void setup_setinfo0 ();
static void setup_setinfo1 ();
static void setup_setinfo2 ();
static void setup_setinfo3 ();
static void setup_setinfo4 ();
static void setup_displaymode ();
static void setup_setfmt0 ();
static void setup_setfmt1 ();
static void setup_setfmt2 ();
static void setup_setfmt3 ();
static void setup_displayformat ();
static void setup_setshortenmethod0 ();
static void setup_setshortenmethod1 ();
static void setup_shortenmethod ();
static void save_playlist (const char *filename);
static void load_playlist (const char *filename);

#ifndef DEBUG
static
#endif
void fatal_error (const char *msg, ...)
	__attribute__ ((format (printf,1,2)));

/*
 * Menu structures
 */

static const MenuRec opt_setupmenu[] =
{
   { 1, "Set the default audio search path", &setup_setaudiopath },
   { 2, "Set the default playlist search path", &setup_setplaylistpath },
   { 3, "Enable/Disable confirmation dialogs", &setup_confirmdialogs },
   { 4, "Set player command", &setup_setplayer },
   { 5, "Set audio type", &setup_setaudiotype },
   { 6, "Set playlist type",&setup_setplaylisttype },
   { 7, "Set fading in/out time", &setup_setfadetime },
   { 8, "Enable/Disable mpg123 player frontend", &setup_mpg123frontend },
   { 9, "Set mpg123 command", &setup_mpg123name },
   { 10, "Enable/Disable intersession memory", &setup_intersessionmemory },
   { 11, "Set track display mode", &setup_displaymode },
   { 12, "Enable/Disable help dialogs", &setup_helpdialogs },
   { 13, "Set track display format", &setup_displayformat },
   { 14, "Set track shortening method", &setup_shortenmethod },
   { 15, "Display current settings", &setup_show },
   { 16, "Save settings", &setup_save },
   { 17, NULL }
};

static const MenuRec opt_setupinfo[] =
{
   { 1, "No information", &setup_setinfo0 },
   { 2, "Description file", &setup_setinfo1 },
   { 3, "ID3 tags", &setup_setinfo2 },
   { 4, "Description file / ID3 tags", &setup_setinfo3 },
   { 5, "ID3 tags / Description file", &setup_setinfo4 },
   { 6, NULL }
};

static const MenuRec opt_setupformat[] =
{
   { 1, "Title - Artist (Album)", &setup_setfmt0 },
   { 2, "Title - Artist", &setup_setfmt1 },
   { 3, "Title (Album)", &setup_setfmt2 },
   { 4, "Title", &setup_setfmt3 },
   { 5, NULL }
};

static const MenuRec opt_setupshorten[] =
{
   { 1, "Split and shorten", &setup_setshortenmethod0 },
   { 2, "Truncate", &setup_setshortenmethod1 },
   { 3, NULL }
};

static const MenuRec opt_playlists[] =
{
   { 1, "Save to playlist", &playlists_save },
   { 2, "Load tracks from playlist", &playlists_load },
   { 3, NULL }
};

static const MenuRec opt_newtrack[] =
{
   { 1, "Play selected track", &track_playcurrent },
   { 2, "Play all songs up to track", &track_playupto },
   { 3, "Play all songs from track", &track_playfrom },
   { 4, "Play entire track list", &track_playall },
   { 5, NULL }
};

static const MenuRec opt_curtrack[] =
{
   { 1, "Skip current track", &track_skip },
   { 2, "Stop player", &track_stop },
   { 3, "Pause player", &track_pause },
   { 4, NULL }
};

static const MenuRec opt_stopresumetrack[] =
{
   { 1, "Resume player", &track_resume },
   { 2, "Stop player", &track_stop },
   { 3, NULL }
};

/*
 * Help menu filenames
 */

const char helphelp[] = HELPDIR "/help.hlp";
const char mainhelp[] = HELPDIR "/main.hlp";
const char setuphelp[] = HELPDIR "/setup.hlp";
const char mixerhelp[] = HELPDIR "/mixer.hlp";
const char browsehelp[] = HELPDIR "/browse.hlp";
const char rearrangehelp[] = HELPDIR "/rearrange.hlp";
const char playlistshelp[] = HELPDIR "/playlists.hlp";
const char savehelp[] = HELPDIR "/save.hlp";
const char loadhelp[] = HELPDIR "/load.hlp";
const char newtrackhelp[] = HELPDIR "/newtrack.hlp";
const char curtrackhelp[] = HELPDIR "/curtrack.hlp";
const char stopresumehelp[] = HELPDIR "/stopresume.hlp";
const char pathhelp[] = HELPDIR "/path.hlp";
const char inputhelp[] = HELPDIR "/input.hlp";
const char mpg123help[] = HELPDIR "/mpg123.hlp";

/*
 * Location for configuration file
 */

const char configfile[] = CONFIGFILE;

/*
 * Time we wait before we assume the program has received a given signal
 */
#define DELAY 50000

/*
 * Number of variables
 */

#define CHANNUM 7								 /* Number of channels in mixer */
#define STRNUM  6								 /* Number of string variables in configuration file */
#define BOOLNUM 4								 /* Number of boolean variables in configuration file */
#define INTNUM  4								 /* Number of integer variables in configuration file */

/*
 * Variable indexes
 */

/* String indexes */
#define AUDIOPATH       0
#define PLAYLISTPATH    1
#define PLAYERNAME      2
#define AUDIOTYPE       3
#define PLAYLISTTYPE    4
#define MPG123NAME      5

/* Integer indexes */
#define FADINGTIME  	0
#define DISPLAYMODE 	1
#define DISPLAYFORMAT	2
#define SHORTENMETHOD	3

/* Boolean indexes */
#define CONFIRMDIALOGS      0
#define MPG123FRONTEND      1
#define INTERSESSIONMEMORY  2
#define HELPDIALOGS			3

/*
 * Variable names
 */

/* Channel variable names */
static const char *chanstr[CHANNUM] = { "volume", "bass", "treble", "synth", "pcm", "ogain", "balance" };

/* String variable names */
static const char *strnam[STRNUM] = { "audiopath", "playlistpath", "playername", "audiotype", "playlisttype", "mpg123name" };

/* Boolean variable names */
static const char *boolnam[BOOLNUM] = { "confirmdialogs", "mpg123frontend", "intersessionmemory", "helpdialogs" };

/* Integer variable names */
static const char *intnam[INTNUM] = { "fadingtime", "displaymode", "displayformat", "shortenmethod" };

/*
 * Initial settings
 */

/* Initial settings of the string variables */
static const char *strini[STRNUM] = { "/", "/", "mpg123 -v -b 16384", "*.[Mm][Pp]3", "*.[Jj][Pp][Ll]", "mpg123 -R -" };

/* Initial settings of the boolean variables */
static const bool boolini[BOOLNUM] = { TRUE, TRUE, TRUE, TRUE };

/* Initial settings of the integer variables */
static const int intini[INTNUM] = { 50, 3, 1, 0 };

#endif
