/*
JuffEd - An advanced text editor
Copyright 2007-2009 Mikhail Murzin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License 
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __JUFF_LOG_H__
#define __JUFF_LOG_H__

#include <QtCore/QString>
#include <QtCore/QRect>

namespace Log {
	void printToLog(const QString&, bool canBeSkipped = false);
	void printToLog(int, bool canBeSkipped = false);
	void debug(const QString&, bool canBeSkipped = false);
	void debug(const char*, bool canBeSkipped = false);
	void debug(int, bool canBeSkipped = false);
	void debug(const QRect&, bool canBeSkipped = false);
	void warning(const QString& str, bool canBeSkipped = false);
};

#ifdef JUFF_FULL_DEBUG

#include <QtCore/QFileInfo>

#define JUFFENTRY Log::debug(QString("Entering %1 (%2:%3)").arg(__FUNCTION__).arg(QFileInfo(__FILE__).fileName()).arg(__LINE__))
#define JUFFDTOR Log::debug(QString("Destructor: %1").arg(__FUNCTION__))
#define JUFFDEBUG(x) Log::debug(QString("DEBUG (%1:%2): %3").arg(QFileInfo(__FILE__).fileName()).arg(__LINE__).arg(x))
#define JUFFDEBUG2(x) Log::debug(QString("DEBUG2 (%1:%2): %3").arg(QFileInfo(__FILE__).fileName()).arg(__LINE__).arg(x))
#define JUFFENTRY2 JUFFENTRY
#define JUFFWARNING(x) Log::warning(QString("WARNING (%1:%2): %3").arg(QFileInfo(__FILE__).fileName()).arg(__LINE__).arg(x))

#else	//	JUFF_FULL_DEBUG

//-----------------
#ifdef JUFF_DEBUG

#include <QtCore/QFileInfo>

#define JUFFENTRY Log::debug(QString("Entering %1 (%2:%3)").arg(__FUNCTION__).arg(QFileInfo(__FILE__).fileName()).arg(__LINE__))
#define JUFFDTOR Log::debug(QString("Destructor: %1").arg(__FUNCTION__))
#define JUFFDEBUG(x) Log::debug(QString("DEBUG (%1:%2): %3").arg(QFileInfo(__FILE__).fileName()).arg(__LINE__).arg(x))
#define JUFFWARNING(x) Log::warning(QString("WARNING (%1:%2): %3").arg(QFileInfo(__FILE__).fileName()).arg(__LINE__).arg(x))

#else	//	JUFF_DEBUG

#define JUFFENTRY ;
#define JUFFDTOR ;
#define JUFFDEBUG(x) ;
#define JUFFWARNING(x) ;

#endif	//	JUFF_DEBUG
//-----------------

#define JUFFDEBUG2(x) ;
#define JUFFENTRY2 ;

#endif	//	JUFF_FULL_DEBUG

#endif	//	__JUFF_LOG_H__
