

/*
 * The JTS Topology Suite is a collection of Java classes that
 * implement the fundamental operations required to validate a given
 * geo-spatial data set to a known topological specification.
 *
 * Copyright (C) 2001 Vivid Solutions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, contact:
 *
 *     Vivid Solutions
 *     Suite #1A
 *     2328 Government Street
 *     Victoria BC  V8T 5G5
 *     Canada
 *
 *     (250)385-6040
 *     www.vividsolutions.com
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;

/**
 * Contains information about the nature and location of a {@link Geometry}
 * validation error
 *
 * @version 1.6
 */
public class TopologyValidationError {

  public static final int ERROR                   = 0;
  public static final int REPEATED_POINT          = 1;
  public static final int HOLE_OUTSIDE_SHELL      = 2;
  public static final int NESTED_HOLES            = 3;
  public static final int DISCONNECTED_INTERIOR   = 4;
  public static final int SELF_INTERSECTION       = 5;
  public static final int RING_SELF_INTERSECTION  = 6;
  public static final int NESTED_SHELLS           = 7;
  public static final int DUPLICATE_RINGS         = 8;
  public static final int TOO_FEW_POINTS          = 9;
  public static final int INVALID_COORDINATE      = 10;

  // these messages must synch up with the indexes above
  private static String[] errMsg = {
    "Topology Validation Error",
    "Repeated Point",
    "Hole lies outside shell",
    "Holes are nested",
    "Interior is disconnected",
    "Self-intersection",
    "Ring Self-intersection",
    "Nested shells",
    "Duplicate Rings",
    "Too few points in geometry component",
    "Invalid Coordinate"
  };


  private int errorType;
  private Coordinate pt;

  public TopologyValidationError(int errorType, Coordinate pt)
  {
    this.errorType = errorType;
    this.pt = (Coordinate) pt.clone();
  }
  public TopologyValidationError(int errorType)
  {
    this(errorType, null);
  }

  public Coordinate getCoordinate() { return pt; }

  public int getErrorType() { return errorType; }

  public String getMessage() { return errMsg[errorType]; }

  public String toString()
  {
    return getMessage() + " at or near point " + pt;
  }
}
