import _jpilot
import baseclasses
import os

class databaseAccessor(baseclasses.databaseAccessor):
    def __init__(self):
        self._writeDatabaseFunction= _jpilot.SaveObjectToJpilotDatabase
        self._deleteFromDatabaseFunction = _jpilot.DeleteObjectFromJpilotDatabase
        assert _jpilot.check_hidden_dir() == 0
        assert _jpilot.check_copy_DBs_to_home() == 0
        baseclasses.databaseAccessor.__init__(self)
        
class addressBook(databaseAccessor, baseclasses.addressBook):
    def __init__(self):
        self._appInfoFunction      = _jpilot.w_read_AddressAppInfo
        self._readDatabaseFunction = _jpilot.w_jp_read_AddressDB
        self._database             = "AddressDB"
        databaseAccessor.__init__(self)

class memoList(databaseAccessor, baseclasses.memoList):
    def __init__(self):
        self._appInfoFunction      = _jpilot.w_read_MemoAppInfo
        self._readDatabaseFunction = _jpilot.w_jp_read_MemoDB
        self._database             = "MemoDB"
        databaseAccessor.__init__(self)
        
class memo32List(databaseAccessor, baseclasses.memoList):
    def __init__(self):
        self._appInfoFunction      = _jpilot.w_read_MemoAppInfo
        self._readDatabaseFunction = _jpilot.w_jp_read_MemoDB
        self._database             = "Memo32DB"
        databaseAccessor.__init__(self)
        
class taskList(databaseAccessor, baseclasses.taskList):
    def __init__(self):
        self._appInfoFunction      = _jpilot.w_read_ToDoAppInfo
        self._readDatabaseFunction = _jpilot.w_jp_read_ToDoDB
        self._database             = "ToDoDB"
        databaseAccessor.__init__(self)

class calendar(databaseAccessor, baseclasses.calendar):
    def __init__(self):
        self._appInfoFunction      = _jpilot.w_read_AppointmentAppInfo
        self._readDatabaseFunction = _jpilot.w_jp_read_DatebookDB
        self._database             = "DatebookDB"
        databaseAccessor.__init__(self)

home = '%s/.jpilot' % (os.getenv('JPILOT_HOME') or os.getenv('HOME'))


def installFile(filename):
    f = open(os.path.join(home,"jpilot_to_install"),"a")
    f.write("%s\n" % filename)
    f.close()
