import base
import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import gtkspell
import gobject
import gnome.ui
import mx.DateTime
import tempfile
import ConfigParser
import os.path
import tempfile
import popen2

from gtk_models import ContactsModel

try:
    from Asterisk.Manager import Manager as AsteriskManager
except:
    AsteriskManager = None

try:
    from clickatell.http import sms as SMSManager
except:
    SMSManager = None

try:
    import lightblue
except ImportError:
    lightblue = None


import jppy
from jppy.printers import contact_printer, contact_label
from jppy.latex import letter


class pane(base.pane):
    def __init__(self, glade_path=os.path.join("@@python_module_prefix@@","gui")):

        gladefile  = os.path.join(glade_path, "contacts.glade")
        wTree      = gtk.glade.XML(gladefile,"vpanedContacts")
        wTreeMenu  = gtk.glade.XML(gladefile,"contactsLogMenu")
        self.name  = "Contacts"
        self.model = ContactsModel()
        self.main_vpaned = wTree.get_widget("vpanedContacts")
        self.view = wTree.get_widget("ContactsTreeView")
        self.recordCategoryOpenMenu = wTree.get_widget("ContactsCategoryOptionMenu")
        self.categoryFilterVBox = wTree.get_widget("ContactsCategoryVBox")

        wTree.get_widget("contactsDialButton").set_sensitive(AsteriskManager != None)

        try:
            mode = jppy.config.get("sms","mode")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError), e:
            mode = None
        if mode == "clickatell" and SMSManager == None:
            wTree.get_widget("contactsSMSButton").set_sensitive(False)

        cb = wTree.get_widget("birthdayCheckbox")
        w  = wTree.get_widget("birthdayDateEdit")
        self.joinValidCheckboxToWidget(cb, w, self.on_dateedit_change)

        cb = wTree.get_widget("birthdayRemindCheckbutton")
        w  = wTree.get_widget("birthdayRemindSpinbutton")
        self.joinValidCheckboxToWidget(cb, w, self.on_entry_change)

        # unsupported fields
        wTree.get_widget("ContactsPrivateCheckButton").set_sensitive(False)

        base.pane.__init__(self, gladefile, wTree)

        self.translateGUI(wTree)

        wTree.get_widget("contactsLogButton").set_menu(
            wTreeMenu.get_widget("contactsLogMenu"))

        self.deleteButton = wTree.get_widget("contactsDeleteButton")

        # prepare for bringing up UI
        dic = {
            "on_ContactsTreeView_button_press_event": (self.on_TreeView_button_press_event,
                                                       self.rightClickColumnMenu),
            "on_ContactsFilterButton_clicked": (self.on_FilterButton, "ContactsFilterEntry"),
            "on_ContactsFilterCheckbox_toggled": (self.on_FilterTypeCheckbox, "ContactsFilterEntry"),
            "on_ContactsFilterEntry_keyrelease": (self.on_FilterEntry_keyrelease, self.model),
            
            "on_contactsRevertButton_clicked": (self.on_RevertButton, self.model),
            "on_contactsNewButton_clicked": (self.on_NewButton, self.model,
                                             self.view, "LastNameEntry"),
            "on_contactsDeleteButton_clicked": (self.on_DeleteButton),
            "on_contactsTopButton_clicked": (self.on_TopButton),
            "on_contactsBottomButton_clicked": (self.on_BottomButton),

            "on_contactsPrintLabelButton_clicked": (self.on_contactsPrintLabelorLetterButton,
                                                    "label"),
            "on_contactsCreateLetterButton_clicked": (self.on_contactsPrintLabelorLetterButton,
                                                      "letter"),

            "on_contactsPrintButton_clicked": (self.on_contactsPrintButton),
            "on_contactsVcardButton_clicked": (self.on_contactsVcardButton),
            "on_changeImageButton_clicked": (self.on_changeImageButton),
            "on_removeImageButton_clicked": (self.on_removeImageButton),
            "on_contactsDialButton_clicked": (self.on_contactsDialButton),
            "on_contactsSMSButton_clicked": (self.on_contactsSMSButton),
            "on_contactsEmailButton_clicked": (self.on_contactsEmailButton)            
            }

        wTree.signal_autoconnect(dic)

        dic = {
            "on_contactsAddLogButton_clicked": (self.on_contactsAddLogButton),
            "on_contactsIncomingCallButton_clicked": (self.on_contactsAddLogInsertButton,
                                                      "Incoming Call"),
            "on_contactsOutgoingCallButton_clicked": (self.on_contactsAddLogInsertButton,
                                                      "Outgoing Call"),
            "on_contactsIncomingPostButton_clicked": (self.on_contactsAddLogInsertButton,
                                                      "Incoming Post"),
            "on_contactsOutgoingPostButton_clicked": (self.on_contactsAddLogInsertButton,
                                                      "Outgoing Post"),
            "on_contactsIncomingEmailButton_clicked": (self.on_contactsAddLogInsertButton,
                                                       "Incoming Email"),
            "on_contactsOutgoingEmailButton_clicked": (self.on_contactsAddLogInsertButton,
                                                       "Outgoing Email")
            }
        
        wTreeMenu.signal_autoconnect(dic)

        wTree.get_widget("PhoneLabel1").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel2").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel3").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel4").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel5").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel6").connect("changed",self.updateDefaultPhoneMenu)
        wTree.get_widget("PhoneLabel7").connect("changed",self.updateDefaultPhoneMenu)

    def translateGUI(self, wTree):
        labels = self.model._database.getContactLabels()
        wTree.get_widget("labellastname").set_label(labels[0])
        wTree.get_widget("labelfirstname").set_label(labels[1])
        wTree.get_widget("labelcompany").set_label(labels[2])
        wTree.get_widget("labeltitle").set_label(labels[3])
        wTree.get_widget("labelwebsite").set_label(labels[13])

        labels = self.model._database.getAddressLabels()
        wTree.get_widget("labelcity1").set_label(labels[0])
        wTree.get_widget("labelcity2").set_label(labels[0])
        wTree.get_widget("labelcity3").set_label(labels[0])
        wTree.get_widget("labelstate1").set_label(labels[1])
        wTree.get_widget("labelstate2").set_label(labels[1])
        wTree.get_widget("labelstate3").set_label(labels[1])
        wTree.get_widget("labelzip1").set_label(labels[2])
        wTree.get_widget("labelzip2").set_label(labels[2])
        wTree.get_widget("labelzip3").set_label(labels[2])
        wTree.get_widget("labelcountry1").set_label(labels[3])
        wTree.get_widget("labelcountry2").set_label(labels[3])
        wTree.get_widget("labelcountry3").set_label(labels[3])
        
        labels = self.model._database.getLabels()
        for i in range(1,10):
            wTree.get_widget("labelcustom%d" % i).set_label(labels[i-1])

    def validWidgetCheckboxToggle(self, cb, widget):
        if cb.get_active():
            widget.set_sensitive(True)
        else:
            widget.set_sensitive(False)
            
    def focus_notes(self):
        notebook = self.wTree.get_widget("ContactsNotebook")
        notebook.set_current_page(1)
        textview = self.wTree.get_widget("ContactsNote")
        buffer = textview.get_buffer()
        textview.grab_focus()
        return textview, buffer

    def updateDefaultPhoneMenu(self,w=None):
        if self.iter:
            contact = self.model.get_value(self.iter,0)
            self.wTree.get_widget("contactsEmailButton").set_sensitive(contact['email'] != None)
            showphone = self.wTree.get_widget("Showphone")
            showphone.set_data("iter", None)
            setting = showphone.get_history()
            menu = gtk.Menu()
            labels = self.model.get_value(self.iter,
                                          self.model.getColumnForNamesList(
                self.model.findAttributeNumberByName("showphone")))
            for label in labels:
                menuitem = gtk.MenuItem(label=label)
                menuitem.show()
                menu.append(menuitem)
            showphone.remove_menu()
            showphone.set_menu(menu)
            showphone.set_history(setting)
            showphone.set_data("iter", self.iter)
        
    def updateDetailsView(self, iter):
        contact = self.model.get_value(iter,0)

        #import pdb
        #pdb.set_trace()
        #print 1
        
        labels = self.model._database.getAddressTypeLabels()
        self.wTree.get_widget("AddrTabLabel1").set_text(labels[contact['typeaddr1']])
        self.wTree.get_widget("AddrTabLabel2").set_text(labels[contact['typeaddr2']])
        self.wTree.get_widget("AddrTabLabel3").set_text(labels[contact['typeaddr3']])

        self.wTree.get_widget("contactsEmailButton").set_sensitive(contact['email'] != None)

        image = self.wTree.get_widget("contactImage")
        if contact['picture']:
            loader = gtk.gdk.PixbufLoader()
            try:
                if loader.write(contact['picture']) and loader.close():
                    pixbuf = loader.get_pixbuf()
                    image.set_from_pixbuf(pixbuf)
                    image.set_child_visible(True)
                    self.wTree.get_widget('removeImageButton').set_sensitive(True)
                else:
                    # can't use .clear() yet, no 2.8...
                    image.set_from_stock("ICON_SIZE_BUTTON",1)
                    image.set_child_visible(False)
                    self.wTree.get_widget('removeImageButton').set_sensitive(False)
            except gobject.GError, e:
                image.set_from_stock("ICON_SIZE_BUTTON",1)
                image.set_child_visible(False)
                self.wTree.get_widget('removeImageButton').set_sensitive(True)
                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Error with picture for %s: %s" % (contact, e))
                d.run()
                d.destroy()
                    
        else:
            # can't use .clear() yet, no 2.8...
            image.set_from_stock("ICON_SIZE_BUTTON",1)
            image.set_child_visible(False)
            self.wTree.get_widget('removeImageButton').set_sensitive(False)            
        base.pane.updateDetailsView(self, iter)
        self.updateDefaultPhoneMenu()

    def on_contactsPrintButton(self, widget):
        contact = self.model.get_value(self.iter,0)
        render = contact_printer(jppy.addressBook(),contact)
        render.display()
        self.model.set_value(self.iter,0,contact)
        self.updateDetailsView(self.iter)

    def on_contactsDialButton(self, widget):
        try:
            host = jppy.config.get("asterisk","host")
            port = jppy.config.get("asterisk","port")
            user = jppy.config.get("asterisk","user")
            password = jppy.config.get("asterisk","password")
            context = jppy.config.get("asterisk","context")
            phone = jppy.config.get("asterisk","phone")
            dialprefix = jppy.config.get("asterisk","dialprefix")            
        except ConfigParser.NoOptionError, e:
            d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                  "Error with ~/.jppyrc: %s" % (e))
            d.run()
            d.destroy()
            return
        dialog = gtk.glade.XML(self.gladefile,"dialDialog")
        w = dialog.get_widget("dialDialog")

        dialog.get_widget("labelHost").set_text(host)
        dialog.get_widget("labelPort").set_text(port)
        dialog.get_widget("labelUser").set_text(user)
        dialog.get_widget("labelContext").set_text(context)
        dialog.get_widget("labelLocalExt").set_text(phone)

        labels = jppy.addressBook().getPhoneLabels()
        for i, (value, label) in zip(range(1,8),
                                     self.model.get_value(self.iter,0)['phones_with_labels']):
            radio = dialog.get_widget("radiobutton%d" % i)
            if value and label != 4:
                number = dialprefix + "".join([x for x in value if x.isdigit()])
                radio.set_label("%s (%s)" % (number, labels[label]))
                radio.set_data("number", number)
                if label == 0:
                    radio.set_active(True)
            else:
                radio.hide()

        called = False
        response = w.run()
        if response in (gtk.RESPONSE_CLOSE, gtk.RESPONSE_CANCEL):
            w.destroy()
        elif response == gtk.RESPONSE_OK:
            for radio in dialog.get_widget("radiobutton1").get_group():
                if radio.get_active() and radio.get_property('visible'):
                    print "Dialing %s" % radio.get_data("number")
                    try:
                        m = AsteriskManager((host,int(port)), user, password, listen_events=False)
                        m.Originate(phone,
                                    extension=radio.get_data("number"),
                                    context=context,
                                    priority=1)
                        called = radio.get_data("number")
                    except Exception, e:
                        d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                              "Error with Asterisk: %s" % (e))
                        d.run()
                        d.destroy()

            w.destroy()

        if called:
            log_message = "\n\n%s\nCalled %s: " % (mx.DateTime.now().strftime("%c"),
                                                   called)
            notebook = self.wTree.get_widget("ContactsNotebook")
            notebook.set_current_page(1)
            textview = self.wTree.get_widget("ContactsNote")
            buffer = textview.get_buffer()
            buffer.insert(buffer.get_end_iter(),log_message)
            dialog.get_widget("spinbuttonSMSlength").get_value_as_int()

    def on_contactsSMSLengthChange(self, buffer, dialog):
        # ignore buffer that we were passed, so we can be called without it
        buffer = dialog.get_widget("textviewSMS").get_buffer()
        begin  = buffer.get_start_iter()
        end    = buffer.get_end_iter()
        label  = dialog.get_widget("labelSMSLength")
        message_length = len(buffer.get_text(begin,end,True))
        smsconfig = self.fetchSMSConfig()
        if not smsconfig:
            return
        max_len = dialog.get_widget("spinbuttonSMSlength").get_value_as_int()
        if smsconfig.has_key('apiid'):
            s = SMSManager(smsconfig['user'], smsconfig['apiid'], smsconfig['password'],
                           ssl=1, max_len=max_len)
            message_supported = s.maxlengthsupported()
        else:
            message_supported = 160*max_len            
        label.set_text("%s (of %s)" % (message_length, message_supported))
        dialog.get_widget("buttonSMSOK").set_property('sensitive', message_length <= message_supported)

    def fetchSMSConfig(self):
        try:
            mode = jppy.config.get("sms","mode")
        except (ConfigParser.NoSectionError, ConfigParser.NoOptionError), e:
            d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                  "Error with ~/.jppyrc: No [sms]/mode set")
            d.run()
            d.destroy()
            return False            
        if mode == "clickatell":
            try:
                smsconf = {'apiid': jppy.config.get("sms","apiid"),
                           'user': jppy.config.get("sms","username"),
                           'password': jppy.config.get("sms","password"),
                           'frm': jppy.config.get("sms","from")}
            except ConfigParser.NoOptionError, e:
                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Error with ~/.jppyrc: %s" % (e))
                d.run()
                d.destroy()
                return False
            try:
                smsconf['callback'] = jppy.config.get("sms","callback")
            except ConfigParser.NoOptionError, e:
                smsconf['callback'] = '0'
        else:
            try:
                smsconf = {'command': jppy.config.get("sms","command")}
            except ConfigParser.NoOptionError, e:
                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Error with ~/.jppyrc: %s" % (e))
                d.run()
                d.destroy()
                return False
        return smsconf                

    def on_contactsSMSButton(self, widget):
        smsconfig = self.fetchSMSConfig()
        if not smsconfig:
            return
        dialog = gtk.glade.XML(self.gladefile,"smsDialog")
        w = dialog.get_widget("smsDialog")

        if smsconfig.has_key('apiid'):
            dialog.get_widget("frameClickatell").show()
            dialog.get_widget("frameShellCommand").hide()            
            dialog.get_widget("labelUsername").set_text(smsconfig['user'])
            dialog.get_widget("labelFrom").set_text(smsconfig['frm'])
            dialog.get_widget("labelApiId").set_text(smsconfig['apiid'])
        else:
            dialog.get_widget("frameShellCommand").show()
            dialog.get_widget("frameClickatell").hide()
            dialog.get_widget("labelShellCommand").set_text(smsconfig['command'])            

        labels = jppy.addressBook().getPhoneLabels()
        for i, (value, label) in zip(range(1,8),
                                     self.model.get_value(self.iter,0)['phones_with_labels']):
            radio = dialog.get_widget("radiobuttonsms%d" % i)
            if value and label != 4:
                number = "".join([x for x in value if x.isdigit()])
                radio.set_label("%s (%s)" % (number, labels[label]))
                radio.set_data("number", number)
                if label == 7:
                    radio.set_active(True)
            else:
                radio.hide()
            
        gtkspell.Spell(dialog.get_widget("textviewSMS"))
        buffer = dialog.get_widget("textviewSMS").get_buffer()
        buffer.connect("changed",
                       self.on_contactsSMSLengthChange,
                       dialog)
        dialog.get_widget("spinbuttonSMSlength").connect("changed",
                                      self.on_contactsSMSLengthChange,
                                      dialog)
        response = w.run()
        if response in (gtk.RESPONSE_CLOSE, gtk.RESPONSE_CANCEL):
            w.destroy()
        elif response == gtk.RESPONSE_OK:
            send_failed_reason = None
            text = None
            id_list = []
            targetnumber = None
            for radio in dialog.get_widget("radiobuttonsms1").get_group():
                if radio.get_active() and radio.get_property('visible'):
                    targetnumber = radio.get_data("number")
                    print "SMS to %s" % targetnumber
                    buffer = dialog.get_widget("textviewSMS").get_buffer()
                    text   = buffer.get_text(buffer.get_start_iter(),
                                             buffer.get_end_iter(),True)
                    max_len = dialog.get_widget("spinbuttonSMSlength").get_value_as_int()
                    w.destroy()
                    try:
                        if smsconfig.has_key('apiid'):
                            s = SMSManager(smsconfig['user'], smsconfig['apiid'], smsconfig['password'],
                                           ssl=1, max_len=max_len, ack=True, callback=smsconfig['callback'])
                            id_list = s.sendmsg(targetnumber,
                                                frm=smsconfig['frm'],
                                                msg=text)
                        else:
                            child = popen2.Popen4(smsconfig['command'].replace('%t',targetnumber))
                            child.tochild.write(text)
                            child.tochild.close()
                            child.wait()
                            output = child.fromchild.read()
                            if output:
                                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                                      "Error with SMS: %s" % output)
                                d.run()
                                d.destroy()
                                send_failed_reason = output
                    except Exception, e:
                        d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                              "Error with SMS: %s" % (e))
                        d.run()
                        d.destroy()
                        send_failed_reason = str(e)
            w.destroy()
            if text:
                if send_failed_reason:
                    event = "FAILED to send SMS to %s (%s)" % (send_failed_reason,
                                                                targetnumber)
                else:
                    if id_list:
                        event = "Sent SMS to ID %s" % (id_list)
                    else:
                        event = "Sent SMS"
                log_message = "\n\n%s\n%s: %s" % (mx.DateTime.now().strftime("%c"),
                                                  event,
                                                  text)
                notebook = self.wTree.get_widget("ContactsNotebook")
                notebook.set_current_page(1)
                textview = self.wTree.get_widget("ContactsNote")
                buffer = textview.get_buffer()
                buffer.insert(buffer.get_end_iter(),log_message)


    def on_contactsEmailButton(self, widget):
        self._execCommandFromConfig("core","emailer",
                                    self.model.get_value(self.iter,0))
        
    def on_removeImageButton(self, widget):
        self.model.get_value(self.iter,0)['picture'] = None
        self.updateDetailsView(self.iter)

    def on_changeImageButton(self, widget, w=None):
        if not w:
            dialog = gtk.glade.XML(self.gladefile,"imageChooserDialog")
            w = dialog.get_widget("imageChooserDialog")
        response = w.run() 
        if response in (gtk.RESPONSE_CLOSE, gtk.RESPONSE_CANCEL):
            w.destroy()
        elif response == gtk.RESPONSE_OK:
            print "File ", w.get_filename()
            try:
                pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(w.get_filename(), 144, 144)
            except gobject.GError, e:
                d = gtk.MessageDialog(w, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Error with file %s: %s" % (w.get_filename(), e))
                d.run()
                d.destroy()
                # now we'll run the main dialog again, so they can repick or cancel.
                return self.on_changeImageButton(None, w)
            w.destroy()

            def store_as_picture(buf, user_data):
                if user_data['picture']:
                    user_data['picture'] = user_data['picture'] + buf
                else:
                    user_data['picture'] = buf
            contact = self.model.get_value(self.iter,0)
            contact['picture'] = None
            pixbuf.save_to_callback(store_as_picture, "jpeg", user_data=contact)
            self.updateDetailsView(self.iter)
        else:
            print "Unknown dialog response?"
            w.destroy()

    def on_contactsVcardButton(self, widget):
        dialog = gtk.glade.XML(self.gladefile,"vcardDialog")

        for radio in dialog.get_widget("radiobuttonSimple").get_group():
            radio.connect_object("toggled", self.on_contactsVcardRadio,
                             radio, dialog, self.iter)  

        w = dialog.get_widget("vcardDialog")
        w.connect_object("response", self.on_contactsVcardResponse,
                         w, dialog, self.iter)

        # But then, how do we disconnect ?
        #hid = self.model.connect("row_changed", self.on_contactsVcardRadio,
        #                                 w, dialog, iter)
        
        self.on_contactsVcardRadio(dialog.get_widget("radiobuttonSimple"),
                                   dialog,
                                   self.iter)

    def on_contactsVcardRadio(self, widget, wtree, iter, a1=None,a2=None,a3=None,a4=None):
        # we can get hit by either row_changed, or by radio button changes.
        #print a1, a2, a3
        #print widget, wtree, iter
        if a2:
            wtree = a2
        #print a4
        contact = self.model.get_value(iter,0)
        text = "No type selected"
        for radio in wtree.get_widget("radiobuttonSimple").get_group():
            if radio.get_active():
                if radio.name == "radiobuttonComplete":
                    text = contact.vcard()
                else:
                    text = contact.vcard(minimal=True)
        buffer = wtree.get_widget("vcardTextView").get_buffer()
        buffer.set_text(text)

    def on_contactsVcardResponse(self, dialog, response, wtree, iter):
        # print iter
        # print response
        buffer = wtree.get_widget("vcardTextView").get_buffer()
        begin  = buffer.get_start_iter()
        end    = buffer.get_end_iter()
        text   = buffer.get_text(begin,end,True)
        if response == 1:
            if lightblue == None:
                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Please install lightblue from http://lightblue.sourceforge.net/")
                d.run()
                d.destroy()
                return
            obexDialog = gtk.glade.XML(self.gladefile,"btobexDialog")
            model = gtk.ListStore(gtk.gdk.Pixbuf, str, str)
            iconview = obexDialog.get_widget('iconviewDevices')
            iconview.set_model(model)
            iconview.set_pixbuf_column(0)
            iconview.set_text_column(1)
            self.on_contactsVcardBTScan(obexDialog, model, iconview)

            w = obexDialog.get_widget('btobexDialog')
            w.connect_object("response", self.on_contactsVcardResponseConnect,
                             w, model, iconview,text, dialog)

            w = obexDialog.get_widget('buttonScan')
            w.connect_object("clicked", self.on_contactsVcardBTScan,
                             w, model, iconview)
        elif response == 2:
            savedialog = gtk.glade.XML(self.gladefile,"vcardSaveDialog")
            w = savedialog.get_widget("vcardSaveDialog")
            contact = self.model.get_value(iter,0)
            if contact['firstname'] and contact['lastname']:
                w.set_current_name("%(firstname)s_%(lastname)s.vcf" % dict(contact))
            elif contact['firstname']:
                w.set_current_name("%(firstname)s.vcf" % dict(contact))
            elif contact['lastname']:
                w.set_current_name("%(lastname)s.vcf" % dict(contact))
            elif contact['company']:
                w.set_current_name("%(company)s.vcf" % dict(contact))
            else:
                w.set_current_name("contact.vcf")
                
            response = w.run()
            if response in (gtk.RESPONSE_CLOSE, gtk.RESPONSE_CANCEL):
                w.destroy()
            elif response == gtk.RESPONSE_OK:
                print "File ", w.get_filename()
                try:
                    open(w.get_filename(),"w").write(text)
                except Exception, e:
                    d = gtk.MessageDialog(w, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                          "Error saving to %s: %s" % (w.get_filename(), e))
                    d.run()
                    d.destroy()
                w.destroy()                
                dialog.destroy()
        else:
            dialog.destroy()            
    def on_contactsVcardBTScan(self, dialog, model, iconview):
        model.clear()
        for address, name, deviceclass in  lightblue.finddevices():
            model.append([iconview.render_icon(gtk.STOCK_NETWORK,
                                               gtk.ICON_SIZE_LARGE_TOOLBAR),
                          name,
                          address])        

    def on_contactsVcardResponseConnect(self, dialog, response, model, iconview, text, vcarddialog):
        if response == gtk.RESPONSE_OK:
            addresses = [model.get_value(model.get_iter(path),
                                         2) for path in iconview.get_selected_items()]
            if len(addresses) == 0:
                d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                                      "Use cancel button if you don't wish to send any cards.")
                d.run()
                d.destroy()
                return
            filename = tempfile.mktemp(".vcf")
            open(filename,'w').write(text)
            for address in addresses:
                print "Sending to %s" % address
                lightblue.obex.sendfile(address,11,filename)
            os.unlink(filename)
            dialog.destroy()
            vcarddialog.destroy()
        else:
            dialog.destroy()
        
    def on_contactsPrintLabelorLetterButton(self, widget, type):
        dialog=gtk.glade.XML(self.gladefile,"printAddressLabelDialog")

        contact = self.model.get_value(self.iter,0)

        labels = self.model._database.getAddressTypeLabels()
        # well, even though I don't like code duplication...
        label = "%s\n(%s...)" % (labels[contact['typeaddr1']],contact['address1'])
        dialog.get_widget("radiobuttonaddr1").set_property("label",label)
        dialog.get_widget("radiobuttonaddr1").set_data("address",1)        

        label = "%s\n(%s...)" % (labels[contact['typeaddr2']],contact['address2'])
        dialog.get_widget("radiobuttonaddr2").set_property("label",label)
        dialog.get_widget("radiobuttonaddr2").set_data("address",2)

        label = "%s\n(%s...)" % (labels[contact['typeaddr3']],contact['address3'])
        dialog.get_widget("radiobuttonaddr3").set_property("label",label)
        dialog.get_widget("radiobuttonaddr3").set_data("address",3)        

        w = dialog.get_widget("printAddressLabelDialog")
        if type == "label":
            w.set_property('title','Print Address Label')
        elif type == "letter":
            w.set_property('title','Create Letter')
            dialog.get_widget("checkbuttonSenderInclude").set_property('sensitive',False)
        else:
            w.set_property('title','Select address to use')
            dialog.get_widget("checkbuttonSenderInclude").set_property('sensitive',False)
            
        w.connect_object("response", self.on_contactsPrintLabelorLetterResponse,
                         w, dialog, self.iter, type)
            

    def on_contactsPrintLabelorLetterResponse(self, dialog, response, wtree, iter, type):
        if response == gtk.RESPONSE_OK:
            buffer = wtree.get_widget("labelLogTextView").get_buffer()
            begin  = buffer.get_start_iter()
            end    = buffer.get_end_iter()
            text   = buffer.get_text(begin,end,True)        

            sender = wtree.get_widget("checkbuttonSenderInclude").get_active()
            
            for radio in wtree.get_widget("radiobuttonaddr1").get_group():
                if radio.get_active():
                    contact = self.model.get_value(iter,0)

                    if type == "label":
                        l = contact_label(jppy.addressBook(), contact,
                                          select=radio.get_data("address"),
                                          sender=sender)
                        l.hardcopy(log=text)
                    elif type == "letter":
                        l = letter(contact,
                                   select=radio.get_data("address"),
                                   sender=sender)
                        l.display(log=text)                        
                    self.model.set_value(iter,0,contact)
                    self.updateDetailsView(iter)        
                    
        dialog.destroy()

    def on_contactsAddLogButton(self, widget):
        dialog=gtk.glade.XML(self.gladefile,"askForLogEntryDialog")
        w = dialog.get_widget("askForLogEntryDialog")
        textview = dialog.get_widget("logEntryTextView")
        buffer = textview.get_buffer()
        w.connect_object("response", self.on_contactsAddLogResponse, w, buffer, self.iter)

    def on_contactsAddLogResponse(self, dialog, response, buffer, iter):
        print buffer, iter
        if response == gtk.RESPONSE_OK:
            begin = buffer.get_start_iter()
            end   = buffer.get_end_iter()
            text = buffer.get_text(begin,end,True)
            contact = self.model.get_value(iter,0)
            #print text
            contact.log(text)
            #print contact['note']
            print contact.unsaved_changes
            self.model.set_value(iter,0,contact)
            self.updateDetailsView(iter)        
        dialog.destroy()

    def on_contactsAddLogInsertButton(self, widget, event_name):
        base_template1 = "\n\n%s\n%s from: " % (mx.DateTime.now().strftime("%c"),
                                                event_name)
        base_template2 = "\nAbout: "
        
        notebook = self.wTree.get_widget("ContactsNotebook")
        notebook.set_current_page(1)
        textview = self.wTree.get_widget("ContactsNote")
        buffer = textview.get_buffer()


        buffer.insert(buffer.get_end_iter(),base_template1)
        mark = buffer.create_mark(None,buffer.get_end_iter(),left_gravity=True)
        buffer.insert(buffer.get_end_iter(),base_template2)        

        buffer.place_cursor(buffer.get_iter_at_mark(mark))
        buffer.delete_mark(mark)

        textview.scroll_mark_onscreen(buffer.get_insert())
        textview.grab_focus()
