#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jmp.h>
#include <cls.h>
#include <method.h>
#include <jmpthread.h>
#include <jmptime.h>

#include <ui_file.h>

/** dump a method to the given file */
void dump_method_row (method* m, FILE* f) {
    jlong jsec, jnsec, hsec, hnsec; 
    methodtime* mt;
    cls* c = method_get_owner (m);
    mt = method_get_time_used (m);
    jmptime_set_time_values (mt->tv, &jsec, &jnsec);
    jmptime_set_time_values (mt->tv_hold, &hsec, &hnsec);
    fprintf (f, "%s\t%s\t%lld.%09lld\t%ld\t%lld.%09lld\t%d\t%lld\n", 
	     cls_get_name (c),
	     method_get_method_jmpname (m),
	     jsec,
	     jnsec,
	     method_get_calls (m),
	     hsec, 
	     hnsec,
	     method_get_allocated_objects (m),
	     method_get_allocated_memory (m));
}

void dump_jmpthread_row (jmpthread* t, FILE* f) {
    method* mp = NULL;
    timerstack* s;
    int i;

    fprintf (f, "%p\t%s\t%s\t%s\t\n",
	     t->env_id,
	     jmpthread_get_thread_name(t),
	     jmpthread_get_group_name(t),
	     jmpthread_get_parent_name(t));

    /* MW: Hack  */
    /* I dont see why this is neccessary /robo */
    if (strcmp (jmpthread_get_thread_name (t), "Shutdown-Thread") == 0) {
        return;
    }

    s = get_timerstack ((JNIEnv*)t->env_id);
    for (i = s->top - 1; i >= 0; i--) {
	methodtime* mt = s->times + i;
	mp = mt->method;
	if (mp != NULL) 
	    fprintf (f, "\t%s\t%s\n",
		     cls_get_name (mp->owner),
		     method_get_method_jmpname (mp));
	else 
	    fprintf (f, "\t?\t?\n" );	    	
    }
}

/** Dump a class to the given file. */
void dump_class_row (cls* c, FILE* f) {
    fprintf (f, "%s\t%ld\t%ld\t%ld\t%ld\t%ld\n", 
	     cls_get_name (c),
	     cls_get_instances (c),
	     cls_get_max_instances (c),
	     cls_get_size (c),
	     cls_get_total_gc (c),
	     cls_get_tenure (c));
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
