#ifndef JMPDEBUG_H__
#define JMPDEBUG_H__

/* Compile with -DJMPDEBUG to get lots of traces, can be helpful sometimes. */
#ifndef JMPDEBUG
 #ifdef __GNUC__
  /* GCC varargs macro trick */
  #define trace(str, args...)
 #else
  #define trace(a) 
 #endif
 #define trace2(a,b) 
 #define trace3(a,b,c)
 #define trace4(a,b,c,d)
 #define trace5(a,b,c,d,e)
#else
 #ifdef __GNUC__
  /* GCC varargs macro trick */
  #define trace(str, args...) do { fprintf (stderr, str , ## args); } while(0)
 #else
  #define trace(a) do { fprintf (stderr, a); fflush (stderr); } while(0)
 #endif
 #define trace2(a,b) do { fprintf (stderr, a, b); fflush (stderr); } while(0)
 #define trace3(a,b,c) do { fprintf (stderr, a, b, c); fflush (stderr); } while(0)
 #define trace4(a,b,c,d) do { fprintf (stderr, a, b, c, d); fflush (stderr); } while(0)
 #define trace5(a,b,c,d,e) do { fprintf (stderr, a, b, c, d, e); fflush (stderr); } while(0)
#endif /* JMPDEBUG */

#if defined(HAVE_SYS_TIME_H)
 #include <sys/time.h>
 #define TIMEVAL_TYPE struct timeval
#elif defined(HAVE_SYS_TIMEB_H)
 #include <sys/timeb.h>
 #define TIMEVAL_TYPE struct timeb
#endif
#ifdef TIMEVAL_TYPE
extern void print_timestamp (TIMEVAL_TYPE *tv_dest, const TIMEVAL_TYPE *tv_last, const char *msg);
#endif

#endif /* JMPDEBUG_H__ */
